/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.gui.chess.CheckState;
import com.dairymoose.modernlife.blocks.gui.chess.ChessScreen;
import com.dairymoose.modernlife.renderer.tileentity.ChessBoardBlockEntityRenderer;
import com.dairymoose.modernlife.tileentities.ChessBoardBlockEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class ChessBoardBlock
extends Block
implements EntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);

    public ChessBoardBlock(BlockBehaviour.Properties p_i48377_1_) {
        super(p_i48377_1_);
    }

    public InteractionResult m_6227_(BlockState p_225533_1_, Level p_225533_2_, final BlockPos pos, Player p_225533_4_, InteractionHand p_225533_5_, BlockHitResult p_225533_6_) {
        if (p_225533_2_.f_46443_) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    ChessScreen screen = new ChessScreen(pos);
                    Minecraft.m_91087_().m_91152_((Screen)screen);
                }
            });
        }
        return InteractionResult.CONSUME;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        ChessBoardBlockEntity toReturn = (ChessBoardBlockEntity)ChessBoardBlockEntity.CHESS_BOARD.m_155264_(pos, state);
        return toReturn;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity e;
        if (!worldIn.f_46443_ && (e = worldIn.m_7702_(pos)) instanceof ChessBoardBlockEntity) {
            ChessBoardBlockEntity tile = (ChessBoardBlockEntity)e;
            tile.m_6836_(0, itemStack.m_41777_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockReader, List<Component> list, TooltipFlag tooltipFlag) {
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("BoardState")) {
            CompoundTag boardState = itemStack.m_41783_().m_128469_("BoardState");
            int currentTurn = boardState.m_128451_("CurrentTurn");
            String whitePlayer = boardState.m_128461_("WhitePlayer");
            String blackPlayer = boardState.m_128461_("BlackPlayer");
            int newCheckState = boardState.m_128451_("NewCheckState");
            boolean gameOver = false;
            if (newCheckState == CheckState.BLACK_CHECKMATE.ordinal()) {
                gameOver = true;
                list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("White won the game!")));
            } else if (newCheckState == CheckState.WHITE_CHECKMATE.ordinal()) {
                gameOver = true;
                list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Black won the game!")));
            } else {
                list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Game in progress...")));
            }
            list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("")));
            list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Turn counter: " + currentTurn)));
            list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("White player: " + whitePlayer)));
            list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Black player: " + blackPlayer)));
            if (!gameOver) {
                boolean isWhiteTurn = boardState.m_128471_("IsWhiteTurn");
                if (isWhiteTurn) {
                    list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("White's turn")));
                } else {
                    list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Black's turn")));
                }
            }
        } else {
            list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Place it down and begin a new game!")));
        }
    }

    public void m_6810_(BlockState p_196243_1_, Level p_196243_2_, final BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.m_60713_(p_196243_4_.m_60734_())) {
            BlockEntity lvt_6_1_ = p_196243_2_.m_7702_(p_196243_3_);
            if (lvt_6_1_ instanceof Container) {
                if (p_196243_2_.f_46443_) {
                    DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                        @Override
                        public void run() {
                            ChessBoardBlockEntityRenderer.stateMap.remove(p_196243_3_);
                        }
                    });
                }
                Containers.m_19002_((Level)p_196243_2_, (BlockPos)p_196243_3_, (Container)((Container)lvt_6_1_));
                p_196243_2_.m_46717_(p_196243_3_, (Block)this);
            }
            super.m_6810_(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return SHAPE;
    }
}

