/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.entity.DummyEntity;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BathtubBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING;
    public static final EnumProperty<TubHalf> HALF;
    public static final BooleanProperty WATERLOGGED;
    protected static final VoxelShape SHAPE_EAST;
    protected static final VoxelShape SHAPE_SOUTH;
    protected static final VoxelShape SHAPE_WEST;
    protected static final VoxelShape SHAPE_NORTH;

    public BathtubBlock(BlockBehaviour.Properties p_i48413_1_) {
        super(p_i48413_1_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)((Object)TubHalf.back))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public FluidState m_5888_(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76192_.m_75953_(3, false) : super.m_5888_(p_204507_1_);
    }

    public BlockState m_6843_(BlockState p_52790_, Rotation p_52791_) {
        return (BlockState)p_52790_.m_61124_((Property)FACING, (Comparable)p_52791_.m_55954_((Direction)p_52790_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_52787_, Mirror p_52788_) {
        return p_52788_ == Mirror.NONE ? p_52787_ : p_52787_.m_60717_(p_52788_.m_54846_((Direction)p_52787_.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        Direction lvt_5_1_ = (Direction)p_220053_1_.m_61143_((Property)FACING);
        if (p_220053_1_.m_61143_(HALF) == TubHalf.front) {
            switch (lvt_5_1_) {
                default: {
                    return SHAPE_EAST;
                }
                case SOUTH: {
                    return SHAPE_SOUTH;
                }
                case WEST: {
                    return SHAPE_WEST;
                }
                case NORTH: 
            }
            return SHAPE_NORTH;
        }
        switch (lvt_5_1_) {
            default: {
                return SHAPE_WEST;
            }
            case SOUTH: {
                return SHAPE_NORTH;
            }
            case WEST: {
                return SHAPE_EAST;
            }
            case NORTH: 
        }
        return SHAPE_SOUTH;
    }

    public BlockState m_7417_(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, LevelAccessor p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        TubHalf lvt_7_1_ = (TubHalf)((Object)p_196271_1_.m_61143_(HALF));
        Direction checkDir = null;
        checkDir = p_196271_1_.m_61143_((Property)FACING) == Direction.EAST ? Direction.WEST : (p_196271_1_.m_61143_((Property)FACING) == Direction.WEST ? Direction.EAST : (p_196271_1_.m_61143_((Property)FACING) == Direction.NORTH ? Direction.SOUTH : Direction.NORTH));
        if (lvt_7_1_ == TubHalf.back && p_196271_5_.m_121945_(checkDir).equals((Object)p_196271_6_) && !p_196271_3_.m_60713_((Block)this)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (lvt_7_1_ == TubHalf.front && p_196271_5_.m_121945_(checkDir.m_122424_()).equals((Object)p_196271_6_) && !p_196271_3_.m_60713_((Block)this)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    protected static void preventCreativeDropFromBottomPart(Level p_241471_0_, BlockPos p_241471_1_, BlockState p_241471_2_, Player p_241471_3_) {
        BlockPos blockpos;
        BlockState blockstate;
        TubHalf BenchHalf2 = (TubHalf)((Object)p_241471_2_.m_61143_(HALF));
        if (BenchHalf2 == TubHalf.front && (blockstate = p_241471_0_.m_8055_(blockpos = p_241471_1_.m_7495_())).m_60734_() == p_241471_2_.m_60734_()) {
            if (blockstate.m_61143_(HALF) == TubHalf.back) {
                p_241471_0_.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
                p_241471_0_.m_5898_(p_241471_3_, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
            }
        }
    }

    public void m_5707_(Level p_176208_1_, BlockPos p_176208_2_, BlockState p_176208_3_, Player p_176208_4_) {
        if (!p_176208_1_.f_46443_ && p_176208_4_.m_7500_()) {
            BathtubBlock.preventCreativeDropFromBottomPart(p_176208_1_, p_176208_2_, p_176208_3_, p_176208_4_);
        }
        super.m_5707_(p_176208_1_, p_176208_2_, p_176208_3_, p_176208_4_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_196258_1_) {
        BlockPos lvt_2_1_ = p_196258_1_.m_8083_();
        if (lvt_2_1_.m_123342_() < p_196258_1_.m_43725_().m_151558_() && p_196258_1_.m_43725_().m_8055_(lvt_2_1_.m_121945_(p_196258_1_.m_8125_())).m_60629_(p_196258_1_)) {
            Level lvt_3_1_ = p_196258_1_.m_43725_();
            boolean lvt_4_1_ = lvt_3_1_.m_276867_(lvt_2_1_) || lvt_3_1_.m_276867_(lvt_2_1_.m_7494_());
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)p_196258_1_.m_8125_().m_122424_())).m_61124_(HALF, (Comparable)((Object)TubHalf.back));
        }
        return null;
    }

    public ItemStack m_142598_(LevelAccessor p_154560_, BlockPos p_154561_, BlockState p_154562_) {
        if (((Boolean)p_154562_.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            p_154560_.m_7731_(p_154561_, (BlockState)p_154562_.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
            return new ItemStack((ItemLike)Items.f_42447_);
        }
        return ItemStack.f_41583_;
    }

    public InteractionResult m_6227_(BlockState p_225533_1_, Level p_225533_2_, BlockPos p_225533_3_, Player player, InteractionHand p_225533_5_, BlockHitResult p_225533_6_) {
        if (player.m_20202_() != null && p_225533_1_.m_61143_(HALF) == TubHalf.front) {
            if (((Boolean)p_225533_1_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                this.m_142598_((LevelAccessor)p_225533_2_, p_225533_3_, p_225533_1_);
                BlockPos otherPos = p_225533_3_.m_121945_((Direction)p_225533_1_.m_61143_((Property)FACING));
                BlockState otherState = p_225533_2_.m_8055_(otherPos);
                if (otherState.m_60713_((Block)CustomBlocks.BLOCK_BATHTUB.get())) {
                    this.m_142598_((LevelAccessor)p_225533_2_, otherPos, otherState);
                }
            } else {
                this.m_7361_((LevelAccessor)p_225533_2_, p_225533_3_, p_225533_1_, Fluids.f_76193_.m_5613_().m_76145_());
                BlockPos otherPos = p_225533_3_.m_121945_((Direction)p_225533_1_.m_61143_((Property)FACING));
                BlockState otherState = p_225533_2_.m_8055_(otherPos);
                if (otherState.m_60713_((Block)CustomBlocks.BLOCK_BATHTUB.get())) {
                    this.m_7361_((LevelAccessor)p_225533_2_, otherPos, otherState, Fluids.f_76193_.m_5613_().m_76145_());
                }
                p_225533_2_.m_5594_(null, p_225533_3_, SoundEvents.f_11917_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        } else if (!p_225533_2_.f_46443_) {
            DummyEntity dummy = DummyEntity.getEntity(-0.1f, p_225533_2_, p_225533_3_, true);
            dummy.ride(player);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level p_180633_1_, BlockPos p_180633_2_, BlockState p_180633_3_, LivingEntity p_180633_4_, ItemStack p_180633_5_) {
        p_180633_1_.m_7731_(p_180633_2_.m_121945_(p_180633_4_.m_6350_()), (BlockState)p_180633_3_.m_61124_(HALF, (Comparable)((Object)TubHalf.front)), 3);
    }

    public boolean m_7898_(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        BlockPos lvt_4_1_ = p_196260_3_.m_7495_();
        BlockState lvt_5_1_ = p_196260_2_.m_8055_(lvt_4_1_);
        return p_196260_1_.m_61143_(HALF) == TubHalf.back ? lvt_5_1_.m_60783_((BlockGetter)p_196260_2_, lvt_4_1_, Direction.UP) : lvt_5_1_.m_60713_((Block)this);
    }

    public PushReaction getPistonPushReaction(BlockState p_149656_1_) {
        return PushReaction.DESTROY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long m_7799_(BlockState p_209900_1_, BlockPos p_209900_2_) {
        return Mth.m_14130_((int)p_209900_2_.m_123341_(), (int)p_209900_2_.m_6625_(p_209900_1_.m_61143_(HALF) == TubHalf.back ? 0 : 1).m_123342_(), (int)p_209900_2_.m_123343_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{HALF, FACING, WATERLOGGED});
    }

    static {
        SHAPE_EAST = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)3.0, (double)10.0, (double)16.0), Block.m_49796_((double)3.0, (double)1.0, (double)0.0, (double)16.0, (double)10.0, (double)2.0), Block.m_49796_((double)3.0, (double)1.0, (double)14.0, (double)16.0, (double)10.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        SHAPE_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST);
        SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
        SHAPE_NORTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST);
        FACING = HorizontalDirectionalBlock.f_54117_;
        HALF = EnumProperty.m_61587_((String)"half", TubHalf.class);
        WATERLOGGED = BlockStateProperties.f_61362_;
    }

    public static enum TubHalf implements StringRepresentable
    {
        back,
        front;


        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

