/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.entity;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.ServerboundFuelLevelPacket;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MotorboatEntity
extends Entity
implements Container,
MenuProvider {
    public static final EntityType<MotorboatEntity> MOTORBOAT_ENTITY = EntityType.Builder.m_20704_(MotorboatEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_(new ResourceLocation("modernlife", "motorboat").toString());
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.m_135353_(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.m_135353_(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ID_PADDLE_LEFT = SynchedEntityData.m_135353_(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_PADDLE_RIGHT = SynchedEntityData.m_135353_(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_BUBBLE_TIME = SynchedEntityData.m_135353_(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ID_ADDED_FREE_GAS = SynchedEntityData.m_135353_(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_ID_FUEL_LEVEL = SynchedEntityData.m_135353_(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final int PADDLE_LEFT = 0;
    public static final int PADDLE_RIGHT = 1;
    private static final int TIME_TO_EJECT = 60;
    private static final double PADDLE_SPEED = (double)0.3926991f;
    public static final double PADDLE_SOUND_TIME = 0.7853981852531433;
    public static final int BUBBLE_TIME = 60;
    private final float[] paddlePositions = new float[2];
    private float invFriction;
    private float outOfControlTicks;
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private boolean inputLeft;
    private boolean inputRight;
    private boolean inputUp;
    private boolean inputDown;
    private double waterLevel;
    private float landFriction;
    public Status status;
    private Status oldStatus;
    private double lastYd;
    private boolean isAboveBubbleColumn;
    private boolean bubbleColumnDirectionIsDown;
    private float bubbleMultiplier;
    private float bubbleAngle;
    private float bubbleAngleO;
    private float curAccel;
    private float maxAccel = 0.1f;
    private float currentFuelLevelClientOnly = -10.0f;
    public int f_19797_ = 0;
    private boolean backingUp = false;
    private NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private static final int MINUTES_UNTIL_EMPTY = 20;
    private static final int TICKS_PER_SEC = 20;
    private static final int SECS_PER_MINUTE = 60;
    public static final int FULL_FUEL_LEVEL = 24000;

    public MotorboatEntity(EntityType<? extends MotorboatEntity> p_38290_, Level p_38291_) {
        super(p_38290_, p_38291_);
        this.f_19850_ = true;
    }

    public void m_7350_(EntityDataAccessor<?> p_20059_) {
        if (p_20059_ == DATA_ID_FUEL_LEVEL) {
            this.currentFuelLevelClientOnly = ((Float)this.f_19804_.m_135370_(DATA_ID_FUEL_LEVEL)).floatValue();
        }
    }

    public MotorboatEntity(Level p_38293_, double p_38294_, double p_38295_, double p_38296_) {
        this(MOTORBOAT_ENTITY, p_38293_);
        this.m_6034_(p_38294_, p_38295_, p_38296_);
        this.f_19854_ = p_38294_;
        this.f_19855_ = p_38295_;
        this.f_19856_ = p_38296_;
    }

    public float getCurrentFuelLevel() {
        if (this.currentFuelLevelClientOnly <= -10.0f) {
            float fuelLevel = ((Float)this.f_19804_.m_135370_(DATA_ID_FUEL_LEVEL)).floatValue();
            if (fuelLevel < 0.0f) {
                fuelLevel = 1.0f;
            }
            this.currentFuelLevelClientOnly = fuelLevel;
        }
        return this.currentFuelLevelClientOnly;
    }

    public boolean isOutOfFuel() {
        float fuelLevel = this.getCurrentFuelLevel();
        return fuelLevel <= 0.0f;
    }

    public void setSyncedFuelLevel(float newLevel) {
        if (newLevel < 0.0f) {
            newLevel = 0.0f;
        }
        this.f_19804_.m_135381_(DATA_ID_FUEL_LEVEL, (Object)Float.valueOf(newLevel));
        this.currentFuelLevelClientOnly = newLevel;
    }

    public int m_6643_() {
        return 27;
    }

    public float getCurAccel() {
        return this.curAccel;
    }

    public float getMaxAccel() {
        return this.maxAccel;
    }

    protected float m_6380_(Pose p_38327_, EntityDimensions p_38328_) {
        return p_38328_.f_20378_;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_PADDLE_LEFT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_PADDLE_RIGHT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_ADDED_FREE_GAS, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_BUBBLE_TIME, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_FUEL_LEVEL, (Object)Float.valueOf(1.0f));
    }

    public boolean m_7337_(Entity p_38376_) {
        return MotorboatEntity.canVehicleCollide(this, p_38376_);
    }

    public static boolean canVehicleCollide(Entity p_38324_, Entity p_38325_) {
        return (p_38325_.m_5829_() || p_38325_.m_6094_()) && !p_38324_.m_20365_(p_38325_);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean isBackingUp() {
        return this.backingUp;
    }

    protected Vec3 m_7643_(Direction.Axis p_38335_, BlockUtil.FoundRectangle p_38336_) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(p_38335_, p_38336_));
    }

    public double m_6048_() {
        return -0.1;
    }

    public boolean m_6469_(DamageSource p_38319_, float p_38320_) {
        if (this.m_6673_(p_38319_)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            boolean flag;
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + p_38320_ * 10.0f);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, p_38319_.m_7639_());
            boolean bl = flag = p_38319_.m_7639_() instanceof Player && ((Player)p_38319_.m_7639_()).m_150110_().f_35937_;
            if (flag || this.getDamage() > 40.0f) {
                if (!flag && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                    ItemStack boatToSpawn = new ItemStack(new ItemLike(){

                        public Item m_5456_() {
                            return MotorboatEntity.this.getDropItem();
                        }
                    });
                    float fuelLevel = ((Float)this.f_19804_.m_135370_(DATA_ID_FUEL_LEVEL)).floatValue();
                    boatToSpawn.m_41700_("FuelLevel", (Tag)FloatTag.m_128566_((float)fuelLevel));
                    this.m_19983_(boatToSpawn);
                }
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    public void m_6845_(boolean p_38381_) {
        if (!this.m_9236_().f_46443_) {
            this.isAboveBubbleColumn = true;
            this.bubbleColumnDirectionIsDown = p_38381_;
            if (this.getBubbleTime() == 0) {
                this.setBubbleTime(60);
            }
        }
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)this.f_19796_.m_188501_(), this.m_20186_() + 0.7, this.m_20189_() + (double)this.f_19796_.m_188501_(), 0.0, 0.0, 0.0);
        if (this.f_19796_.m_188503_(20) == 0) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5509_(), this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_(), false);
        }
        this.m_146852_(GameEvent.f_157784_, (Entity)this.m_6688_());
    }

    public void m_7334_(Entity p_38373_) {
        if (p_38373_ instanceof MotorboatEntity) {
            if (p_38373_.m_20191_().f_82289_ < this.m_20191_().f_82292_) {
                super.m_7334_(p_38373_);
            }
        } else if (p_38373_.m_20191_().f_82289_ <= this.m_20191_().f_82289_) {
            super.m_7334_(p_38373_);
        }
    }

    public Item getDropItem() {
        return (Item)CustomBlocks.ITEM_MOTORBOAT.get();
    }

    public void animateHurt() {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_6453_(double p_38299_, double p_38300_, double p_38301_, float p_38302_, float p_38303_, int p_38304_, boolean p_38305_) {
        this.lerpX = p_38299_;
        this.lerpY = p_38300_;
        this.lerpZ = p_38301_;
        this.lerpYRot = p_38302_;
        this.lerpXRot = p_38303_;
        this.lerpSteps = 10;
    }

    public Direction m_6374_() {
        return this.m_6350_().m_122427_();
    }

    private void motorboatSound(Level world, Player player, int count) {
        if (count % 4 == 0 && this.status == Status.IN_WATER) {
            if (this.isOutOfFuel()) {
                return;
            }
            float minVolume = 0.7f;
            float maxVolume = 1.0f;
            float volumeDiff = maxVolume - minVolume;
            float currentVolume = minVolume + this.curAccel / this.maxAccel * volumeDiff;
            float minPitch = 1.0f;
            float maxPitch = 1.8f;
            float pitchDiff = maxPitch - minPitch;
            float currentPitch = minPitch + this.curAccel / this.maxAccel * pitchDiff;
            if (currentVolume < minVolume) {
                currentVolume = minVolume;
            }
            if (currentPitch < minPitch) {
                currentPitch = minPitch;
            }
            if (player == null) {
                if (this.m_6109_()) {
                    Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)CustomBlocks.SOUND_BOAT_MOTOR.get(), currentVolume, currentPitch);
                }
            } else {
                world.m_5594_(player, player.m_20183_(), (SoundEvent)CustomBlocks.SOUND_BOAT_MOTOR.get(), SoundSource.BLOCKS, currentVolume, currentPitch);
            }
        }
    }

    public void m_8119_() {
        ++this.f_19797_;
        if (this.m_9236_().f_46443_ && this.m_6109_()) {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Input pInput = Minecraft.m_91087_().f_91074_.f_108618_;
                this.setInput(pInput.f_108570_, pInput.f_108571_, pInput.f_108568_, pInput.f_108569_);
            }
        } else {
            this.setInput(false, false, false, false);
        }
        this.oldStatus = this.status;
        this.status = this.getStatus();
        this.outOfControlTicks = this.status != Status.UNDER_WATER && this.status != Status.UNDER_FLOWING_WATER ? 0.0f : (this.outOfControlTicks += 1.0f);
        if (!this.m_9236_().f_46443_ && this.outOfControlTicks >= 60.0f) {
            this.m_20153_();
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        super.m_8119_();
        this.tickLerp();
        LivingEntity controller = this.m_6688_();
        Player controllingPlayer = null;
        if (controller instanceof Player) {
            controllingPlayer = (Player)controller;
        }
        if (controllingPlayer != null) {
            Vec3 currentPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            Vec3 deltaMov = new Vec3(0.8, 0.0, 0.0).m_82524_(-(this.m_146908_() - 30.0f) * ((float)Math.PI / 180) - 1.5707964f);
            Vec3 deltaMov2 = new Vec3(0.8, 0.0, 0.0).m_82524_(-(this.m_146908_() + 30.0f) * ((float)Math.PI / 180) - 1.5707964f);
            Vec3 scaled1_left = currentPos.m_82549_(deltaMov.m_82490_(1.0));
            Vec3 scaled1_right = currentPos.m_82549_(deltaMov2.m_82490_(1.0));
            BlockPos posToCheck1_left = BlockPos.m_274561_((double)scaled1_left.f_82479_, (double)scaled1_left.f_82480_, (double)scaled1_left.f_82481_).m_7494_();
            BlockPos posToCheck1_right = BlockPos.m_274561_((double)scaled1_right.f_82479_, (double)scaled1_right.f_82480_, (double)scaled1_right.f_82481_).m_7494_();
            BlockState state1 = this.m_9236_().m_8055_(posToCheck1_left);
            BlockState state2 = this.m_9236_().m_8055_(posToCheck1_right);
            if (state1.m_60713_(Blocks.f_50196_) || state2.m_60713_(Blocks.f_50196_)) {
                if (this.m_9236_() instanceof ServerLevel && state1.m_60713_(Blocks.f_50196_)) {
                    this.m_9236_().m_46961_(posToCheck1_left, true);
                }
                if (this.m_9236_() instanceof ServerLevel && state2.m_60713_(Blocks.f_50196_)) {
                    this.m_9236_().m_46961_(posToCheck1_right, true);
                }
            }
            if (this.m_9236_().f_46443_) {
                this.motorboatSound(this.m_9236_(), null, this.f_19797_);
            } else {
                this.motorboatSound(this.m_9236_(), controllingPlayer, this.f_19797_);
            }
        }
        if (this.m_6109_()) {
            if (!(this.m_146895_() instanceof Player)) {
                this.setPaddleState(false, false);
            }
            this.floatMotorboatEntity();
            if (this.m_9236_().f_46443_) {
                this.controlMotorboatEntity();
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.f_19862_) {
                this.curAccel = 0.0f;
            }
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
        this.tickBubbleColumn();
        for (int i = 0; i <= 1; ++i) {
            if (this.getPaddleState(i)) {
                SoundEvent soundevent;
                if (!this.m_20067_() && (double)(this.paddlePositions[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && ((double)this.paddlePositions[i] + (double)0.3926991f) % 6.2831854820251465 >= 0.7853981852531433 && (soundevent = this.getPaddleSound()) != null) {
                    Vec3 vec3 = this.m_20252_(1.0f);
                    double d0 = i == 1 ? -vec3.f_82481_ : vec3.f_82481_;
                    double d1 = i == 1 ? vec3.f_82479_ : -vec3.f_82479_;
                    this.m_9236_().m_6263_((Player)null, this.m_20185_() + d0, this.m_20186_(), this.m_20189_() + d1, soundevent, this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
                    this.m_9236_().m_142346_((Entity)this.m_6688_(), GameEvent.f_157784_, BlockPos.m_274561_((double)(this.m_20185_() + d0), (double)this.m_20186_(), (double)(this.m_20189_() + d1)));
                }
                this.paddlePositions[i] = (float)((double)this.paddlePositions[i] + (double)0.3926991f);
                continue;
            }
            this.paddlePositions[i] = 0.0f;
        }
        this.m_20101_();
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.m_9236_().f_46443_ && !(this.m_6688_() instanceof Player);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.m_20363_((Entity)this)) continue;
                if (flag && this.m_20197_().size() < 4 && !entity.m_20159_() && entity.m_20205_() < this.m_20205_() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) {
                    entity.m_20329_((Entity)this);
                    continue;
                }
                this.m_7334_(entity);
            }
        }
    }

    private void tickBubbleColumn() {
        if (this.m_9236_().f_46443_) {
            int i = this.getBubbleTime();
            this.bubbleMultiplier = i > 0 ? (this.bubbleMultiplier += 0.05f) : (this.bubbleMultiplier -= 0.1f);
            this.bubbleMultiplier = Mth.m_14036_((float)this.bubbleMultiplier, (float)0.0f, (float)1.0f);
            this.bubbleAngleO = this.bubbleAngle;
            this.bubbleAngle = 10.0f * (float)Math.sin(0.5f * (float)this.m_9236_().m_46467_()) * this.bubbleMultiplier;
        } else {
            int k;
            if (!this.isAboveBubbleColumn) {
                this.setBubbleTime(0);
            }
            if ((k = this.getBubbleTime()) > 0) {
                this.setBubbleTime(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.setBubbleTime(0);
                    Vec3 vec3 = this.m_20184_();
                    if (this.bubbleColumnDirectionIsDown) {
                        this.m_20256_(vec3.m_82520_(0.0, -0.7, 0.0));
                        this.m_20153_();
                    } else {
                        this.m_20334_(vec3.f_82479_, this.m_146862_(p_150274_ -> p_150274_ instanceof Player) ? 2.7 : 0.6, vec3.f_82481_);
                    }
                }
                this.isAboveBubbleColumn = false;
            }
        }
    }

    @Nullable
    protected SoundEvent getPaddleSound() {
        switch (this.getStatus()) {
            case IN_WATER: 
            case UNDER_WATER: 
            case UNDER_FLOWING_WATER: {
                return SoundEvents.f_11707_;
            }
            case ON_LAND: {
                return SoundEvents.f_11706_;
            }
        }
        return null;
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    public void setPaddleState(boolean p_38340_, boolean p_38341_) {
        this.f_19804_.m_135381_(DATA_ID_PADDLE_LEFT, (Object)p_38340_);
        this.f_19804_.m_135381_(DATA_ID_PADDLE_RIGHT, (Object)p_38341_);
    }

    public float getRowingTime(int p_38316_, float p_38317_) {
        return this.getPaddleState(p_38316_) ? (float)Mth.m_14085_((double)((double)this.paddlePositions[p_38316_] - (double)0.3926991f), (double)this.paddlePositions[p_38316_], (double)p_38317_) : 0.0f;
    }

    public Status getStatus() {
        Status boat$status = this.isUnderwater();
        if (boat$status != null) {
            this.waterLevel = this.m_20191_().f_82292_;
            return boat$status;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        float f = this.getGroundFriction();
        if (f > 0.0f) {
            this.landFriction = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float getWaterLevelAbove() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)(aabb.f_82292_ - this.lastYd));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(l1, k1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (fluidstate.m_205070_(FluidTags.f_13131_)) {
                        f = Math.max(f, fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutableblockpos.m_123342_() + f;
        }
        return l + 1;
    }

    public float getGroundFriction() {
        AABB aabb = this.m_20191_();
        AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 0.001, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
        int i = Mth.m_14107_((double)aabb1.f_82288_) - 1;
        int j = Mth.m_14165_((double)aabb1.f_82291_) + 1;
        int k = Mth.m_14107_((double)aabb1.f_82289_) - 1;
        int l = Mth.m_14165_((double)aabb1.f_82292_) + 1;
        int i1 = Mth.m_14107_((double)aabb1.f_82290_) - 1;
        int j1 = Mth.m_14165_((double)aabb1.f_82293_) + 1;
        VoxelShape voxelshape = Shapes.m_83064_((AABB)aabb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutableblockpos.m_122178_(l1, k2, i2);
                    BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
                    if (blockstate.m_60734_() instanceof WaterlilyBlock || !Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos).m_83216_((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    f += blockstate.getFriction((LevelReader)this.m_9236_(), (BlockPos)blockpos$mutableblockpos, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private boolean checkInWater() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82289_);
        int l = Mth.m_14165_((double)(aabb.f_82289_ + 0.001));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_)) continue;
                    float f = (float)l1 + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= aabb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Status isUnderwater() {
        AABB aabb = this.m_20191_();
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_) || !(d0 < (double)((float)blockpos$mutableblockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_WATER : null;
    }

    private void floatMotorboatEntity() {
        double d0 = -0.04f;
        double d1 = this.m_20068_() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.invFriction = 0.05f;
        if (this.oldStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
            this.curAccel = 0.0f;
            this.waterLevel = this.m_20227_(1.0);
            this.m_6034_(this.m_20185_(), (double)(this.getWaterLevelAbove() - this.m_20206_()) + 0.101, this.m_20189_());
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = Status.IN_WATER;
        } else {
            if (this.status == Status.IN_WATER) {
                d2 = (this.waterLevel - this.m_20186_()) / (double)this.m_20206_();
                this.invFriction = 0.9f;
            } else if (this.status == Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.invFriction = 0.9f;
            } else if (this.status == Status.UNDER_WATER) {
                d2 = 0.01f;
                this.invFriction = 0.45f;
            } else if (this.status == Status.IN_AIR) {
                this.invFriction = 0.9f;
            } else if (this.status == Status.ON_LAND) {
                this.invFriction = this.landFriction;
                if (this.m_6688_() instanceof Player) {
                    this.landFriction /= 2.0f;
                }
            }
            Vec3 vec3 = this.m_20184_();
            this.m_20334_(vec3.f_82479_ * (double)this.invFriction, vec3.f_82480_ + d1, vec3.f_82481_ * (double)this.invFriction);
            this.deltaRotation *= this.invFriction;
            if (d2 > 0.0) {
                Vec3 vec31 = this.m_20184_();
                this.m_20334_(vec31.f_82479_, (vec31.f_82480_ + d2 * 0.06153846016296973) * 0.75, vec31.f_82481_);
            }
        }
    }

    private void controlMotorboatEntity() {
        if (this.m_20160_()) {
            float accel = 0.0f;
            if (this.inputLeft) {
                this.deltaRotation -= 1.0f;
            }
            if (this.inputRight) {
                this.deltaRotation += 1.0f;
            }
            if (this.status == Status.ON_LAND) {
                this.curAccel = 0.0f;
                if (this.inputRight != this.inputLeft && !this.inputUp && !this.inputDown) {
                    this.curAccel = 0.005f;
                }
                this.m_146922_(this.m_146908_() + this.deltaRotation);
                if (this.inputUp) {
                    this.curAccel = 0.04f;
                }
                this.backingUp = false;
                if (this.inputDown) {
                    this.curAccel = -0.04f;
                }
            } else {
                float maxNegativeAccel;
                float speedDivisor = 70.0f;
                if (this.inputRight != this.inputLeft && !this.inputUp && !this.inputDown) {
                    accel += 0.005f / speedDivisor;
                }
                this.m_146922_(this.m_146908_() + this.deltaRotation);
                if (this.inputUp) {
                    accel = this.curAccel == 0.0f ? (accel += 0.03f) : (accel += 0.04f / speedDivisor);
                }
                this.backingUp = false;
                if (this.inputDown) {
                    if (this.curAccel > 0.0f) {
                        accel -= 0.15f / speedDivisor;
                    } else {
                        this.backingUp = true;
                        accel -= 0.04f / speedDivisor;
                    }
                }
                float deaccelWithNoInput = 0.015f;
                if (!this.inputUp && !this.inputDown) {
                    if (this.curAccel > 0.0f) {
                        this.curAccel -= deaccelWithNoInput / speedDivisor;
                    } else if (this.curAccel < 0.0f) {
                        this.curAccel += deaccelWithNoInput / speedDivisor;
                    }
                    if (this.curAccel > 0.0f && this.curAccel <= deaccelWithNoInput) {
                        this.curAccel = 0.0f;
                    }
                    if (this.curAccel < 0.0f && this.curAccel >= -deaccelWithNoInput) {
                        this.curAccel = 0.0f;
                    }
                }
                this.curAccel += accel;
                if (this.curAccel > this.maxAccel) {
                    this.curAccel = this.maxAccel;
                }
                if (this.curAccel < (maxNegativeAccel = -this.maxAccel / 3.0f)) {
                    this.curAccel = maxNegativeAccel;
                }
                if (this.isOutOfFuel()) {
                    this.curAccel = Math.min(this.curAccel, 0.005f);
                    this.curAccel = Math.max(this.curAccel, -0.005f);
                }
                float ACCEL_FUEL_COEFF = 4.1666665E-4f;
                float newFuelLevel = this.currentFuelLevelClientOnly - Math.abs(this.curAccel) * ACCEL_FUEL_COEFF;
                if (newFuelLevel < 0.0f) {
                    newFuelLevel = 0.0f;
                }
                this.currentFuelLevelClientOnly = newFuelLevel;
                if (this.f_19797_ % 100 == 0) {
                    this.setSyncedFuelLevel(this.currentFuelLevelClientOnly);
                    ModernLifeNetwork.INSTANCE.sendToServer((Object)new ServerboundFuelLevelPacket(this.currentFuelLevelClientOnly, this.m_19879_()));
                }
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * this.curAccel), 0.0, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * this.curAccel)));
            this.setPaddleState(this.inputRight && !this.inputLeft || this.inputUp, this.inputLeft && !this.inputRight || this.inputUp);
        }
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFn) {
        if (this.m_20363_(entity)) {
            int i;
            float f = 0.0f;
            float f1 = (float)((this.m_213877_() ? (double)0.01f : this.m_6048_()) + entity.m_6049_());
            if (this.m_20197_().size() > 0) {
                i = this.m_20197_().indexOf(entity);
                f = 0.5f;
            }
            i = this.m_20197_().indexOf(entity);
            float[] passengerAngles = new float[]{-47.5f, 47.5f, 227.5f, 132.5f};
            Vec3 vec3 = new Vec3((double)f, 0.0, 0.0).m_82524_(-(this.m_146908_() + passengerAngles[i % 4]) * ((float)Math.PI / 180) - 1.5707964f);
            moveFn.m_20372_(entity, this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vec3.f_82481_);
            entity.m_146922_(entity.m_146908_() + this.deltaRotation);
            entity.m_5616_(entity.m_6080_() + this.deltaRotation);
            this.clampRotation(entity);
            if (entity instanceof Animal && this.m_20197_().size() > 1) {
                int j = entity.m_19879_() % 2 == 0 ? 90 : 270;
                entity.m_5618_(((Animal)entity).f_20883_ + (float)j);
                entity.m_5616_(entity.m_6080_() + (float)j);
            }
        }
    }

    protected void m_20351_(Entity entity) {
        if (this.m_9236_().f_46443_) {
            if (entity.m_8077_()) {
                entity.m_20340_(true);
            }
            if (this.m_9236_().f_46443_ && this.m_6688_().m_19879_() == entity.m_19879_() && this.m_6109_()) {
                this.setSyncedFuelLevel(this.currentFuelLevelClientOnly);
                ModernLifeNetwork.INSTANCE.sendToServer((Object)new ServerboundFuelLevelPacket(this.currentFuelLevelClientOnly, this.m_19879_()));
            }
        }
        super.m_20351_(entity);
    }

    public Vec3 m_7688_(LivingEntity entity) {
        Vec3 vec3 = MotorboatEntity.m_19903_((double)(this.m_20205_() * Mth.f_13994_), (double)entity.m_20205_(), (float)entity.m_146908_());
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20189_() + vec3.f_82481_;
        BlockPos blockpos = BlockPos.m_274561_((double)d0, (double)this.m_20191_().f_82292_, (double)d1);
        BlockPos blockpos1 = blockpos.m_7495_();
        if (!this.m_9236_().m_46801_(blockpos1)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.m_9236_().m_45573_(blockpos);
            if (DismountHelper.m_38439_((double)d2)) {
                list.add(new Vec3(d0, (double)blockpos.m_123342_() + d2, d1));
            }
            if (DismountHelper.m_38439_((double)(d3 = this.m_9236_().m_45573_(blockpos1)))) {
                list.add(new Vec3(d0, (double)blockpos1.m_123342_() + d3, d1));
            }
            for (Pose pose : entity.m_7431_()) {
                for (Vec3 vec31 : list) {
                    if (!DismountHelper.m_150279_((CollisionGetter)this.m_9236_(), (Vec3)vec31, (LivingEntity)entity, (Pose)pose)) continue;
                    entity.m_20124_(pose);
                    return vec31;
                }
            }
        }
        return super.m_7688_(entity);
    }

    protected void clampRotation(Entity p_38322_) {
        p_38322_.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(p_38322_.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        p_38322_.f_19859_ += f1 - f;
        p_38322_.m_146922_(p_38322_.m_146908_() + f1 - f);
        p_38322_.m_5616_(p_38322_.m_146908_());
    }

    public void m_7340_(Entity p_38383_) {
        this.clampRotation(p_38383_);
    }

    public InteractionResult m_6096_(Player player, InteractionHand p_38331_) {
        if (player.m_36341_()) {
            if (!this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        if (this.outOfControlTicks < 60.0f) {
            if (!this.m_9236_().f_46443_) {
                ItemStack mainItem = player.m_21205_();
                if (mainItem.m_150930_((Item)CustomBlocks.ITEM_GAS_CAN.get())) {
                    int remainingDurability;
                    float fuelLevel = ((Float)this.f_19804_.m_135370_(DATA_ID_FUEL_LEVEL)).floatValue();
                    int fuelAsInteger = (int)(fuelLevel * 24000.0f);
                    int deficit = 24000 - fuelAsInteger;
                    int durabilityToConsume = Math.min(deficit, remainingDurability = mainItem.m_41776_() - mainItem.m_41773_());
                    if (durabilityToConsume > 0) {
                        mainItem.m_41622_(durabilityToConsume, (LivingEntity)player, p -> {});
                        this.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        float fuelAsFloat = (float)(fuelAsInteger += durabilityToConsume) / 24000.0f;
                        this.setSyncedFuelLevel(fuelAsFloat);
                    }
                    return InteractionResult.CONSUME;
                }
                return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7840_(double p_38307_, boolean p_38308_, BlockState p_38309_, BlockPos p_38310_) {
        this.lastYd = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (p_38308_) {
                if (this.f_19789_ > 3.0f) {
                    if (this.status != Status.ON_LAND) {
                        this.m_183634_();
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, this.m_269291_().m_268989_());
                    if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
                        this.m_6074_();
                        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_(new ItemLike(){

                                    public Item m_5456_() {
                                        return Items.f_41913_;
                                    }
                                });
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                        }
                    }
                }
                this.m_183634_();
            } else if (!this.m_9236_().m_6425_(this.m_20183_().m_7495_()).m_205070_(FluidTags.f_13131_) && p_38307_ < 0.0) {
                this.f_19789_ = (float)((double)this.f_19789_ - p_38307_);
            }
        }
    }

    public boolean getPaddleState(int p_38314_) {
        return (Boolean)this.f_19804_.m_135370_(p_38314_ == 0 ? DATA_ID_PADDLE_LEFT : DATA_ID_PADDLE_RIGHT) != false && this.m_6688_() != null;
    }

    public void setDamage(float p_38312_) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(p_38312_));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int p_38355_) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)p_38355_);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    private void setBubbleTime(int p_38367_) {
        this.f_19804_.m_135381_(DATA_ID_BUBBLE_TIME, (Object)p_38367_);
    }

    private int getBubbleTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_BUBBLE_TIME);
    }

    public float getBubbleAngle(float p_38353_) {
        return Mth.m_14179_((float)p_38353_, (float)this.bubbleAngleO, (float)this.bubbleAngle);
    }

    public void setHurtDir(int p_38363_) {
        this.f_19804_.m_135381_(DATA_ID_HURTDIR, (Object)p_38363_);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURTDIR);
    }

    protected boolean m_7310_(Entity p_38390_) {
        return this.m_20197_().size() < 4 && !this.m_204029_(FluidTags.f_13131_);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity e = this.m_146895_();
        if (e instanceof LivingEntity) {
            return (LivingEntity)e;
        }
        return null;
    }

    public void setInput(boolean p_38343_, boolean p_38344_, boolean p_38345_, boolean p_38346_) {
        this.inputLeft = p_38343_;
        this.inputRight = p_38344_;
        this.inputUp = p_38345_;
        this.inputDown = p_38346_;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean m_5842_() {
        return this.status == Status.UNDER_WATER || this.status == Status.UNDER_FLOWING_WATER;
    }

    protected void m_20348_(Entity passenger) {
        if (passenger.m_8077_()) {
            passenger.m_20340_(false);
        }
        super.m_20348_(passenger);
        if (this.m_146898_()) {
            if (this.m_9236_().f_46443_) {
                this.currentFuelLevelClientOnly = ((Float)this.f_19804_.m_135370_(DATA_ID_FUEL_LEVEL)).floatValue();
            }
            this.curAccel = 0.0f;
        }
        if (this.m_6109_() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.m_19890_(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYRot, (float)this.lerpXRot);
        }
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    public void m_6211_() {
        this.itemStacks.clear();
    }

    public AbstractContainerMenu m_7208_(int var1, Inventory var2, Player var3) {
        if (var3.m_5833_()) {
            return null;
        }
        return ChestMenu.m_39237_((int)var1, (Inventory)var2, (Container)this);
    }

    public Component m_5446_() {
        return MutableComponent.m_237204_((ComponentContents)new LiteralContents("Motorboat"));
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.itemStacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int p_38218_) {
        return (ItemStack)this.itemStacks.get(p_38218_);
    }

    public ItemStack m_7407_(int p_38220_, int p_38221_) {
        return ContainerHelper.m_18969_(this.itemStacks, (int)p_38220_, (int)p_38221_);
    }

    public ItemStack m_8016_(int p_38244_) {
        ItemStack itemstack = (ItemStack)this.itemStacks.get(p_38244_);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.itemStacks.set(p_38244_, (Object)ItemStack.f_41583_);
        return itemstack;
    }

    public void m_6836_(int p_38225_, ItemStack p_38226_) {
        this.itemStacks.set(p_38225_, (Object)p_38226_);
        if (!p_38226_.m_41619_() && p_38226_.m_41613_() > this.m_6893_()) {
            p_38226_.m_41764_(this.m_6893_());
        }
    }

    public SlotAccess m_141942_(final int p_150257_) {
        return p_150257_ >= 0 && p_150257_ < this.m_6643_() ? new SlotAccess(){

            public ItemStack m_142196_() {
                return MotorboatEntity.this.m_8020_(p_150257_);
            }

            public boolean m_142104_(ItemStack p_150265_) {
                MotorboatEntity.this.m_6836_(p_150257_, p_150265_);
                return true;
            }
        } : super.m_141942_(p_150257_);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player p_38230_) {
        if (this.m_213877_()) {
            return false;
        }
        return !(p_38230_.m_20280_((Entity)this) > 64.0);
    }

    public void m_142687_(Entity.RemovalReason p_150255_) {
        if (!this.m_9236_().f_46443_ && p_150255_.m_146965_()) {
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this);
        }
        super.m_142687_(p_150255_);
    }

    protected void m_7380_(CompoundTag p_38248_) {
        if (p_38248_ != null) {
            ContainerHelper.m_18973_((CompoundTag)p_38248_, this.itemStacks);
            p_38248_.m_128350_("FuelLevel", ((Float)this.f_19804_.m_135370_(DATA_ID_FUEL_LEVEL)).floatValue());
        }
    }

    protected void m_7378_(CompoundTag p_38235_) {
        if (p_38235_ != null) {
            ContainerHelper.m_18980_((CompoundTag)p_38235_, this.itemStacks);
            this.f_19804_.m_135381_(DATA_ID_FUEL_LEVEL, (Object)Float.valueOf(p_38235_.m_128457_("FuelLevel")));
        }
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

