/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.entity;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.ServerboundBikeDismountPacket;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class BicycleEntity
extends Entity {
    public static final EntityType<BicycleEntity> BICYCLE_ENTITY = EntityType.Builder.m_20704_(BicycleEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.6f, 1.01f).m_20702_(10).m_20712_(new ResourceLocation("modernlife", "bicycle").toString());
    private float velocity = 0.0f;
    private float downward_velocity = 0.0f;
    public static final float MAX_SPEED = 0.42f;
    public static final float MIN_SPEED = 0.05f;
    public static final float REVERSE_MAX_SPEED = -0.14f;
    public static final int TICKS_PER_JUMP = 6;
    public static final float MAX_ANGLE_DELTA = 10.0f;
    public static final float SPEED_INCREASE_CONSTANT = 0.0085f;
    public float maxSpeedIncrease = 1.0f;
    public Vec3 lastPos = null;
    private float jumpStep = -1.0f;
    public boolean recentDismount = false;
    public float renderWheelRot = 0.0f;
    public Vec3 lastRenderPos = null;
    public long lastRenderTime = 0L;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(BicycleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.m_135353_(BicycleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(BicycleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public void setVelocity(float velocity) {
        this.velocity = velocity;
    }

    public void setSpeedBoost(float speedBoost) {
        this.maxSpeedIncrease = speedBoost;
    }

    public void setDownwardVelocity(float downward_velocity) {
        this.downward_velocity = downward_velocity;
    }

    public void setJumpStep(float jumpStep) {
        this.jumpStep = jumpStep;
    }

    public BicycleEntity(EntityType<? extends BicycleEntity> p_i50238_1_, Level p_i50238_2_) {
        super(p_i50238_1_, p_i50238_2_);
        this.m_274367_(1.0f);
    }

    public void m_6453_(double p_38299_, double p_38300_, double p_38301_, float p_38302_, float p_38303_, int p_38304_, boolean p_38305_) {
        this.lerpX = p_38299_;
        this.lerpY = p_38300_;
        this.lerpZ = p_38301_;
        this.lerpYRot = p_38302_;
        this.lerpXRot = p_38303_;
        this.lerpSteps = p_38304_;
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_20160_()) {
            return super.m_6096_(player, hand);
        }
        if (!this.m_9236_().f_46443_) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    protected void m_19956_(Entity p_184232_1_, Entity.MoveFunction p_289571_) {
        super.m_19956_(p_184232_1_, p_289571_);
        if (p_184232_1_ instanceof Mob) {
            Mob mob = (Mob)p_184232_1_;
        }
        float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
        float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
        float f1 = 0.38f;
        float f2 = 0.65f;
        p_289571_.m_20372_(p_184232_1_, this.m_20185_() + (double)(f1 * f3), this.m_20186_() + this.m_6048_() + p_184232_1_.m_6049_() + (double)f2, this.m_20189_() - (double)(f1 * f));
        if (p_184232_1_ instanceof LivingEntity) {
            // empty if block
        }
    }

    protected boolean m_7310_(Entity p_184219_1_) {
        return this.velocity <= 1.0f && this.m_20197_().size() < 1;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity e;
        Entity entity = e = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (e instanceof LivingEntity) {
            return (LivingEntity)e;
        }
        return null;
    }

    public Vec3 m_7688_(LivingEntity p_230268_1_) {
        return super.m_7688_(p_230268_1_);
    }

    protected void m_20351_(Entity p_184225_1_) {
        ModernLifeCommon.LOGGER.debug((Object)p_184225_1_.m_9236_());
        this.lastPos = null;
        if (p_184225_1_.m_9236_().f_46443_) {
            ModernLifeNetwork.INSTANCE.sendToServer((Object)new ServerboundBikeDismountPacket(this.m_20182_(), this.jumpStep, this.velocity, this.downward_velocity, this.m_19879_()));
        }
        super.m_20351_(p_184225_1_);
    }

    protected void m_20348_(Entity p_184200_1_) {
        this.lastPos = null;
        super.m_20348_(p_184200_1_);
    }

    protected float m_6380_(Pose p_213316_1_, EntityDimensions p_213316_2_) {
        return p_213316_2_.f_20378_;
    }

    private float angularDifference(float angle1, float angle2) {
        float diff;
        if ((angle1 %= 360.0f) < 0.0f) {
            angle1 += 360.0f;
        }
        if ((angle2 %= 360.0f) < 0.0f) {
            angle2 += 360.0f;
        }
        if ((diff = angle2 - angle1) > 180.0f) {
            diff = -(360.0f - diff);
        } else if (diff < -180.0f) {
            diff = 360.0f + diff;
        }
        return diff;
    }

    private void applyNewFacing(float facing) {
        this.m_146922_(facing);
        this.m_19915_(this.m_146908_(), this.m_146909_());
    }

    protected void clampRotation(Entity p_184454_1_) {
        if (p_184454_1_ != null) {
            p_184454_1_.m_5618_(this.m_146908_());
            float f = Mth.m_14177_((float)(p_184454_1_.m_146908_() - this.m_146908_()));
            float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
            p_184454_1_.m_146922_(p_184454_1_.m_146908_() + f1 - f);
            p_184454_1_.m_5616_(p_184454_1_.m_146908_());
        }
    }

    protected void m_7840_(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
        this.f_19789_ *= 0.88f;
        super.m_7840_(p_184231_1_, p_184231_3_, p_184231_4_, p_184231_5_);
    }

    public void setDamage(float p_70266_1_) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(p_70266_1_));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int p_70265_1_) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)p_70265_1_);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURTDIR);
    }

    public void setHurtDir(int p_70269_1_) {
        this.f_19804_.m_135381_(DATA_ID_HURTDIR, (Object)p_70269_1_);
    }

    public Item getDropItem() {
        return (Item)CustomBlocks.ITEM_BICYCLE.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateHurt() {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.m_6673_(p_70097_1_)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            boolean flag;
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + p_70097_2_ * 20.0f);
            this.m_5834_();
            boolean bl = flag = p_70097_1_.m_7639_() instanceof Player && ((Player)p_70097_1_.m_7639_()).m_150110_().f_35937_;
            if (flag || this.getDamage() > 40.0f) {
                if (!flag && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.m_19998_((ItemLike)this.getDropItem());
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return true;
    }

    public void advanceMovement(LivingEntity livingEntity, float speed, boolean jumping) {
        double positionDelta;
        if (this.lastPos != null && (positionDelta = this.m_20182_().m_82554_(this.lastPos)) <= 0.04) {
            if (this.velocity >= 0.05f) {
                this.velocity *= 0.2f;
            }
            if (positionDelta <= 0.01) {
                this.downward_velocity = 0.0f;
            }
        }
        this.velocity = this.downward_velocity == 0.0f ? (this.velocity *= 0.985f) : (this.velocity *= 0.998f);
        if ((double)speed != 0.0 && this.downward_velocity == 0.0f) {
            float speedIncrease = 0.0085f;
            if (speed < 0.0f) {
                speedIncrease *= 0.75f;
            }
            float increment = speed * speedIncrease;
            this.velocity += increment;
            if (this.velocity > 0.42f * this.maxSpeedIncrease) {
                this.velocity = 0.42f * this.maxSpeedIncrease;
            } else if (this.velocity < -0.14f * this.maxSpeedIncrease) {
                this.velocity = -0.14f * this.maxSpeedIncrease;
            }
        } else if (this.velocity > 0.0f && this.velocity <= 0.05f) {
            this.velocity = 0.0f;
        } else if (this.velocity < 0.0f && this.velocity >= -0.05f) {
            this.velocity = 0.0f;
        }
        if (this.maxSpeedIncrease > 1.0f) {
            this.maxSpeedIncrease = 1.0f;
        }
        if (this.m_9236_().m_6425_(this.m_20183_()).m_76152_() != Fluids.f_76191_) {
            this.velocity = (float)((double)this.velocity * 0.9);
        }
        if (this.m_204029_(FluidTags.f_13131_) || this.m_204029_(FluidTags.f_13132_)) {
            this.downward_velocity = (float)((double)this.downward_velocity * 0.2);
        }
        if (this.velocity != 0.0f && livingEntity != null && this.downward_velocity == 0.0f) {
            float facingAngle = livingEntity.m_146908_();
            float livingYRot = livingEntity.m_146908_();
            float bikeYRot = this.m_146908_();
            float angleDelta = this.angularDifference(bikeYRot, livingYRot);
            if (Math.abs(angleDelta) > 10.0f) {
                facingAngle = angleDelta > 0.0f ? bikeYRot + Math.min(Math.abs(angleDelta), 10.0f) : bikeYRot - Math.min(Math.abs(angleDelta), 10.0f);
            }
            this.applyNewFacing(facingAngle);
        }
        BlockState currentState = this.m_9236_().m_8055_(this.m_20183_());
        BlockState currentBelowState = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
        float friction = currentBelowState.getFriction((LevelReader)this.m_9236_(), this.m_20183_().m_7495_(), (Entity)this);
        float frictionPercent = (friction -= 0.6f) / 0.4f;
        float maxFrictionSlowdown = 0.012f;
        float frictionSlowdownFactor = 1.0f - maxFrictionSlowdown * frictionPercent;
        this.velocity *= frictionSlowdownFactor;
        this.m_20334_((double)this.velocity * Math.cos(Math.toRadians(this.m_146908_() + 90.0f)), -this.downward_velocity, (double)this.velocity * Math.sin(Math.toRadians(this.m_146908_() + 90.0f)));
        if (this.m_6063_()) {
            Vec3 fluidFlow = this.m_9236_().m_6425_(this.m_20183_()).m_76179_((BlockGetter)this.m_9236_(), this.m_20183_());
            fluidFlow = fluidFlow.m_82490_(0.01);
            this.m_20256_(this.m_20184_().m_82549_(fluidFlow));
        }
        Vec3 moveToVec = this.m_20182_().m_82549_(new Vec3(this.m_20184_().f_82479_, 0.0, this.m_20184_().f_82481_).m_82490_(2.0));
        BlockPos moveToPos = BlockPos.m_274561_((double)moveToVec.f_82479_, (double)moveToVec.f_82480_, (double)moveToVec.f_82481_);
        BlockState moveToState = this.m_9236_().m_8055_(moveToPos);
        BlockState moveToAboveState = this.m_9236_().m_8055_(moveToPos.m_7494_());
        BlockState moveToBelowState = this.m_9236_().m_8055_(moveToPos.m_7495_());
        boolean pathable = moveToState.m_60734_().m_7357_(moveToState, (BlockGetter)this.m_9236_(), moveToPos, PathComputationType.LAND);
        boolean pathableAbove = moveToAboveState.m_60734_().m_7357_(moveToAboveState, (BlockGetter)this.m_9236_(), moveToPos.m_7494_(), PathComputationType.LAND);
        BlockState stateToCheck = currentState;
        BlockPos posToCheck = this.m_20183_();
        if (stateToCheck.m_60795_()) {
            stateToCheck = currentBelowState;
            posToCheck = posToCheck.m_7495_();
        }
        double currentHeight = 0.0;
        VoxelShape groundShape = stateToCheck.m_60734_().m_5939_(stateToCheck, (BlockGetter)this.m_9236_(), posToCheck, CollisionContext.m_82749_());
        if (!groundShape.equals(Shapes.m_83040_())) {
            currentHeight = groundShape.m_83297_(Direction.Axis.Y);
        }
        double moveToHeight = 0.0;
        VoxelShape moveToShape = moveToState.m_60734_().m_5939_(moveToState, (BlockGetter)this.m_9236_(), moveToPos, CollisionContext.m_82749_());
        if (!moveToShape.equals(Shapes.m_83040_())) {
            moveToHeight = moveToShape.m_83297_(Direction.Axis.Y);
        }
        double jumpHeight = 0.0;
        if (jumping && this.downward_velocity == 0.0f && this.jumpStep < 0.0f) {
            this.jumpStep = 0.0f;
        }
        if (this.jumpStep >= 0.0f) {
            jumpHeight = 0.4 * (double)(this.velocity / 0.42f) * Math.sin(Math.toRadians(this.jumpStep));
            this.jumpStep += 30.0f;
        }
        if (this.jumpStep >= 180.0f) {
            this.jumpStep = -1.0f;
        }
        double heightDiff = moveToHeight - currentHeight;
        double groundY = (double)posToCheck.m_123342_() + currentHeight;
        if (!currentState.m_60795_()) {
            // empty if block
        }
        if (currentBelowState.m_60795_() || this.m_20182_().f_82480_ > groundY) {
            this.downward_velocity += 0.03f;
        } else {
            if (this.downward_velocity != 0.0f && currentBelowState.m_60819_().m_76178_()) {
                float damageDone;
                if (livingEntity != null) {
                    this.applyNewFacing(livingEntity.m_146908_());
                }
                if (!((damageDone = this.downward_velocity * 1.12f) > 1.0f) || livingEntity != null) {
                    // empty if block
                }
                if (livingEntity instanceof Player) {
                    Player Player2 = (Player)livingEntity;
                    float volume = 0.25f;
                    if ((double)damageDone >= 1.0) {
                        this.m_9236_().m_5594_(Player2, this.m_20183_(), SoundEvents.f_11908_, SoundSource.PLAYERS, volume, 1.0f);
                    } else if ((double)damageDone > 0.2) {
                        this.m_9236_().m_5594_(Player2, this.m_20183_(), SoundEvents.f_11916_, SoundSource.PLAYERS, volume, 1.0f);
                    }
                }
            }
            this.downward_velocity = 0.0f;
        }
        this.m_20334_(this.m_20184_().f_82479_, (double)(-this.downward_velocity) + jumpHeight, this.m_20184_().f_82481_);
        this.lastPos = this.m_20182_();
        if (this.m_9236_() instanceof ServerLevel || this.m_20160_() && this.m_6109_()) {
            Vec3 toMove = this.m_20184_();
            if (this.downward_velocity == 0.0f) {
                Vec3 mov = this.m_20184_();
                this.m_20334_(mov.f_82479_, mov.f_82480_ - 0.01, mov.f_82481_);
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public void m_8119_() {
        boolean jumping = false;
        float speed = 0.0f;
        LivingEntity livingEntity = null;
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        if (this.m_9236_().f_46443_) {
            livingEntity = this.m_6688_();
            if (this.m_20160_() && this.m_6109_()) {
                float xDelta = livingEntity.f_20900_;
                float zDelta = livingEntity.f_20902_;
                xDelta = 0.0f;
                if (Minecraft.m_91087_().f_91066_.f_92089_.m_90857_()) {
                    jumping = true;
                }
                speed = xDelta * xDelta + zDelta * zDelta;
                double headingDegrees = Math.toDegrees(Math.atan2(zDelta, xDelta));
                if (headingDegrees < 0.0) {
                    speed = -speed;
                }
            }
            this.advanceMovement(livingEntity, speed, jumping);
        } else if (this.velocity > 0.0f || this.downward_velocity > 0.0f) {
            this.advanceMovement(livingEntity, speed, jumping);
            if (this.velocity == 0.0f && this.recentDismount) {
                this.recentDismount = false;
            }
        }
        super.m_8119_();
        this.tickLerp();
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return true;
    }

    public double m_6048_() {
        return -0.15;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean canWearArmor() {
        return true;
    }

    public boolean isArmor(ItemStack p_190682_1_) {
        return p_190682_1_.m_41720_() instanceof HorseArmorItem;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(CompoundTag var1) {
    }

    protected void m_7380_(CompoundTag var1) {
    }
}

