/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.Consumer;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ChunkManager;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.HeightMapType;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.LightType;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.NativeImage;
import org.mtr.mapping.holder.NativeImageBackedTexture;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.MinecraftClientHelper;
import org.mtr.mod.Init;

public class WorldMap {
    private final Object2ObjectOpenHashMap<IntIntImmutablePair, MapImage> mapImages = new Object2ObjectOpenHashMap();
    private MapOverlayMode mapOverlayMode = MapOverlayMode.TOP_VIEW;
    private double updateMapTimer = -1.0;
    public static final int CHUNK_SIZE = 16;
    private static final int UPDATE_FREQUENCY = 40;
    private static final double LIGHT_DIM_FACTOR = 4.0;

    public void tick(World world, ClientPlayerEntity player, float delta) {
        if (this.updateMapTimer == -1.0 || this.updateMapTimer >= 40.0) {
            this.updateMapTimer = 0.0;
            this.updateMap(World.cast(world), player);
        }
        for (MapImage mapImage : new Object2ObjectOpenHashMap(this.mapImages).values()) {
            if (world.getChunkManager().isChunkLoaded(mapImage.chunkX, mapImage.chunkZ)) continue;
            mapImage.dispose();
            this.mapImages.remove((Object)new IntIntImmutablePair(mapImage.chunkX, mapImage.chunkZ));
        }
        this.updateMapTimer += (double)delta;
    }

    public void forEachTile(Consumer<MapImage> callback) {
        this.mapImages.values().forEach(mapImage -> {
            if (!mapImage.disposed) {
                callback.accept((MapImage)mapImage);
            }
        });
    }

    public void updateMap(World world, ClientPlayerEntity player) {
        int radius = MinecraftClientHelper.getRenderDistance() + 1;
        ChunkManager chunkManager = world.getChunkManager();
        for (int i = -radius; i < radius + 1; ++i) {
            for (int j = -radius; j < radius + 1; ++j) {
                int chunkZ;
                int posX = player.getBlockPos().getX() + i * 16;
                int posZ = player.getBlockPos().getZ() + j * 16;
                int chunkX = (int)Math.floor((double)posX / 16.0);
                if (!chunkManager.isChunkLoaded(chunkX, chunkZ = (int)Math.floor((double)posZ / 16.0))) continue;
                int chunkXStart = chunkX * 16;
                int chunkZStart = chunkZ * 16;
                IntIntImmutablePair chunkXZ = new IntIntImmutablePair(chunkX, chunkZ);
                MapImage mapTexture = (MapImage)this.mapImages.get((Object)chunkXZ);
                if (mapTexture == null) {
                    NativeImage nativeImage = new NativeImage(16, 16, false);
                    mapTexture = new MapImage(chunkX, chunkZ, new NativeImageBackedTexture(nativeImage));
                    this.mapImages.put((Object)chunkXZ, (Object)mapTexture);
                }
                for (int k = 0; k < 16; ++k) {
                    for (int l = 0; l < 16; ++l) {
                        int lightLevel;
                        int blockY;
                        int blockX = chunkXStart + k;
                        int blockZ = chunkZStart + l;
                        int topY = world.getTopY(HeightMapType.getMotionBlockingMapped(), blockX, blockZ) - 1;
                        if (this.mapOverlayMode == MapOverlayMode.TOP_VIEW) {
                            blockY = topY;
                        } else {
                            int currentY = Math.min(topY, player.getBlockPos().getY());
                            if (currentY != topY) {
                                while (currentY >= -64 && world.getBlockState(Init.newBlockPos(blockX, currentY, blockZ)).isAir()) {
                                    --currentY;
                                }
                            }
                            blockY = currentY;
                        }
                        BlockPos finalPos = Init.newBlockPos(blockX, blockY, blockZ);
                        if (this.mapOverlayMode.calculateLight) {
                            BlockPos lightReferencePos = finalPos.up();
                            lightLevel = Math.max(world.getLightLevel(LightType.getBlockMapped(), lightReferencePos), world.getLightLevel(LightType.getSkyMapped(), lightReferencePos));
                        } else {
                            lightLevel = 15;
                        }
                        NativeImage nativeImage = mapTexture.texture.getImage();
                        if (nativeImage == null) continue;
                        nativeImage.setPixelColor(k, l, WorldMap.convertColorABGR(WorldMap.divideColorRGB(world.getBlockState(finalPos).getBlock().getDefaultMapColor().getColorMapped(), this.mapOverlayMode == MapOverlayMode.TOP_VIEW ? 1.5 : 1.0 + (double)(15 - lightLevel) / 4.0)));
                    }
                }
                mapTexture.texture.upload();
            }
        }
    }

    private static int convertColorABGR(int rgb) {
        int a = 255;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return 0xFF000000 | b << 16 | g << 8 | r;
    }

    private static int divideColorRGB(int color, double amount) {
        int r = (int)((double)(color >> 16 & 0xFF) / amount);
        int g = (int)((double)(color >> 8 & 0xFF) / amount);
        int b = (int)((double)(color & 0xFF) / amount);
        return (r << 16) + (g << 8) + b;
    }

    public void setMapOverlayMode(MapOverlayMode overlayMode) {
        this.mapOverlayMode = overlayMode;
    }

    public boolean isMapOverlayMode(MapOverlayMode mapOverlayMode) {
        return this.mapOverlayMode == mapOverlayMode;
    }

    public void disposeImages() {
        for (MapImage image : this.mapImages.values()) {
            image.dispose();
        }
        this.mapImages.clear();
    }

    public static enum MapOverlayMode {
        TOP_VIEW(false),
        CURRENT_Y(true);

        public final boolean calculateLight;

        private MapOverlayMode(boolean calculateLight) {
            this.calculateLight = calculateLight;
        }
    }

    public static class MapImage {
        public final Identifier textureId;
        public final NativeImageBackedTexture texture;
        public final int chunkX;
        public final int chunkZ;
        private boolean disposed;

        private MapImage(int chunkX, int chunkZ, NativeImageBackedTexture texture) {
            this.textureId = MinecraftClient.getInstance().getTextureManager().registerDynamicTexture("mtr_dashboard_map", texture);
            this.texture = texture;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }

        public void dispose() {
            this.disposed = true;
            MinecraftClient.getInstance().getTextureManager().destroyTexture(this.textureId);
        }

        public boolean disposed() {
            return this.disposed;
        }
    }
}

