/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.awt.Color;
import java.util.Locale;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import org.apache.commons.lang3.StringUtils;
import org.mtr.mapping.holder.ButtonWidget;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;

public class WidgetColorSelector
extends ButtonWidgetExtension
implements IGui {
    private int color;
    private final ScreenExtension screen;
    private final boolean hasMargin;
    private final Runnable callback;

    public WidgetColorSelector(ScreenExtension screen, boolean hasMargin, Runnable callback) {
        super(0, 0, 0, 20, TextHelper.literal(""), (ButtonWidget button) -> {});
        this.screen = screen;
        this.hasMargin = hasMargin;
        this.callback = callback;
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        super.render(graphicsHolder, mouseX, mouseY, delta);
        if (this.f_93624_) {
            int margin = this.hasMargin ? 1 : 0;
            GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
            guiDrawing.beginDrawingRectangle();
            guiDrawing.drawRectangle(this.getX2() - margin, this.getY2() - margin, this.getX2() + this.f_93618_ + margin, this.getY2() + this.f_93619_ + margin, 0xFF000000 | this.color);
            guiDrawing.finishDrawingRectangle();
        }
    }

    @Override
    public void onPress2() {
        MinecraftClient.getInstance().openScreen(new Screen(new ColorSelectorScreen(this.color, color -> {
            MinecraftClient.getInstance().openScreen(new Screen(this.screen));
            this.setColor((int)color);
            this.callback.run();
        })));
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int newColor) {
        int clampedColor = (newColor & 0xFFFFFF) == 0 ? new Random().nextInt(0x1000000) : newColor & 0xFFFFFF;
        this.color = clampedColor;
    }

    private static class ColorSelectorScreen
    extends ScreenExtension {
        private float hue;
        private float saturation;
        private float brightness;
        private DraggingState draggingState = DraggingState.NONE;
        private final int oldColor;
        private final Consumer<Integer> colorCallback;
        private final TextFieldWidgetExtension textFieldColor;
        private final TextFieldWidgetExtension textFieldRed;
        private final TextFieldWidgetExtension textFieldGreen;
        private final TextFieldWidgetExtension textFieldBlue;
        private final ButtonWidgetExtension buttonReset;
        private static final int RIGHT_WIDTH = 60;

        private ColorSelectorScreen(int oldColor, Consumer<Integer> colorCallback) {
            this.oldColor = oldColor;
            this.colorCallback = colorCallback;
            this.textFieldColor = new TextFieldWidgetExtension(0, 0, 0, 20, 6, TextCase.UPPER, "[^\\dA-F]", TextHelper.literal(Integer.toHexString(oldColor).toUpperCase(Locale.ENGLISH)).getString());
            this.textFieldRed = new TextFieldWidgetExtension(0, 0, 0, 20, 3, TextCase.DEFAULT, "\\D", TextHelper.literal(String.valueOf(oldColor >> 16 & 0xFF)).getString());
            this.textFieldGreen = new TextFieldWidgetExtension(0, 0, 0, 20, 3, TextCase.DEFAULT, "\\D", TextHelper.literal(String.valueOf(oldColor >> 8 & 0xFF)).getString());
            this.textFieldBlue = new TextFieldWidgetExtension(0, 0, 0, 20, 3, TextCase.DEFAULT, "\\D", TextHelper.literal(String.valueOf(oldColor & 0xFF)).getString());
            this.buttonReset = new ButtonWidgetExtension(0, 0, 0, 20, TranslationProvider.GUI_MTR_RESET_SIGN.getMutableText(new Object[0]), button -> {
                this.setHsb(oldColor, true);
                button.setActiveMapped(false);
            });
        }

        @Override
        protected void init2() {
            super.init2();
            int startX = 80 + this.getMainWidth();
            int startY = 36;
            IDrawing.setPositionAndWidth(this.textFieldColor, startX + 2, 36, 56);
            IDrawing.setPositionAndWidth(this.textFieldRed, startX + 2, 80, 56);
            IDrawing.setPositionAndWidth(this.textFieldGreen, startX + 2, 104, 56);
            IDrawing.setPositionAndWidth(this.textFieldBlue, startX + 2, 128, 56);
            IDrawing.setPositionAndWidth(this.buttonReset, startX, this.getMainHeight(), 60);
            this.setHsb(this.oldColor, true);
            this.textFieldColor.setChangedListener2(text -> this.textCallback((String)text, -1));
            this.textFieldRed.setChangedListener2(text -> this.textCallback((String)text, 16));
            this.textFieldGreen.setChangedListener2(text -> this.textCallback((String)text, 8));
            this.textFieldBlue.setChangedListener2(text -> this.textCallback((String)text, 0));
            this.addChild(new ClickableWidget((AbstractWidget)this.textFieldColor));
            this.addChild(new ClickableWidget((AbstractWidget)this.textFieldRed));
            this.addChild(new ClickableWidget((AbstractWidget)this.textFieldGreen));
            this.addChild(new ClickableWidget((AbstractWidget)this.textFieldBlue));
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonReset));
        }

        @Override
        public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
            this.renderBackground(graphicsHolder);
            super.render(graphicsHolder, mouseX, mouseY, delta);
            int mainWidth = this.getMainWidth();
            int mainHeight = this.getMainHeight();
            graphicsHolder.drawCenteredText(TranslationProvider.GUI_MTR_COLOR.getMutableText(new Object[0]), 80 + mainWidth + 30, 20, -1);
            graphicsHolder.drawCenteredText("RGB", 80 + mainWidth + 30, 64, -1);
            GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
            guiDrawing.beginDrawingRectangle();
            int selectedColor = Color.HSBtoRGB(this.hue, this.saturation, this.brightness);
            guiDrawing.drawRectangle(80 + mainWidth + 1, 157.0, 80 + mainWidth + 60 - 1, mainHeight - 1, selectedColor);
            for (int drawHue = 0; drawHue < mainHeight; ++drawHue) {
                int color = Color.HSBtoRGB((float)drawHue / (float)(mainHeight - 1), 1.0f, 1.0f);
                guiDrawing.drawRectangle(40 + mainWidth, 20 + drawHue, 60 + mainWidth, 20 + drawHue + 1, color);
            }
            for (int drawSaturation = 0; drawSaturation < mainWidth; ++drawSaturation) {
                for (int drawBrightness = 0; drawBrightness < mainHeight; ++drawBrightness) {
                    int color = Color.HSBtoRGB(this.hue, (float)drawSaturation / (float)(mainWidth - 1), (float)drawBrightness / (float)(mainHeight - 1));
                    guiDrawing.drawRectangle(20 + drawSaturation, 20 + mainHeight - drawBrightness - 1, 20 + drawSaturation + 1, 20 + mainHeight - drawBrightness, color);
                }
            }
            int selectedHueInt = Math.round(this.hue * (float)(mainHeight - 1));
            int selectedSaturationInt = Math.round(this.saturation * (float)(mainWidth - 1));
            int selectedBrightnessInt = Math.round(this.brightness * (float)(mainHeight - 1));
            guiDrawing.drawRectangle(40 + mainWidth, 20 + selectedHueInt - 1, 60 + mainWidth, 20 + selectedHueInt + 2, -16777216);
            guiDrawing.drawRectangle(40 + mainWidth, 20 + selectedHueInt, 60 + mainWidth, 20 + selectedHueInt + 1, -1);
            guiDrawing.drawRectangle(20 + selectedSaturationInt - 1, 20 + mainHeight - selectedBrightnessInt - 1, 20 + selectedSaturationInt + 2, 20 + mainHeight - selectedBrightnessInt, -16777216);
            guiDrawing.drawRectangle(20 + selectedSaturationInt, 20 + mainHeight - selectedBrightnessInt - 2, 20 + selectedSaturationInt + 1, 20 + mainHeight - selectedBrightnessInt + 1, -16777216);
            guiDrawing.drawRectangle(20 + selectedSaturationInt, 20 + mainHeight - selectedBrightnessInt - 1, 20 + selectedSaturationInt + 1, 20 + mainHeight - selectedBrightnessInt, -1);
            guiDrawing.finishDrawingRectangle();
        }

        @Override
        public void tick2() {
            this.textFieldRed.tick2();
            this.textFieldGreen.tick2();
            this.textFieldBlue.tick2();
            this.textFieldColor.tick2();
        }

        @Override
        public void onClose2() {
            this.colorCallback.accept(Color.HSBtoRGB(this.hue, this.saturation, this.brightness) & 0xFFFFFF);
        }

        @Override
        public boolean mouseClicked2(double mouseX, double mouseY, int button) {
            int mainWidth = this.getMainWidth();
            int mainHeight = this.getMainHeight();
            this.draggingState = DraggingState.NONE;
            if (mouseY >= 20.0 && mouseY < (double)(20 + mainHeight)) {
                if (mouseX >= 20.0 && mouseX < (double)(20 + mainWidth)) {
                    this.draggingState = DraggingState.SATURATION_BRIGHTNESS;
                } else if (mouseX >= (double)(40 + mainWidth) && mouseX < (double)(60 + mainWidth)) {
                    this.draggingState = DraggingState.HUE;
                }
            }
            this.selectColor(mouseX, mouseY);
            return super.mouseClicked2(mouseX, mouseY, button);
        }

        @Override
        public boolean mouseDragged2(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            this.selectColor(mouseX, mouseY);
            return super.mouseDragged2(mouseX, mouseY, button, deltaX, deltaY);
        }

        private void selectColor(double mouseX, double mouseY) {
            int mainWidth = this.getMainWidth();
            int mainHeight = this.getMainHeight();
            switch (this.draggingState) {
                case SATURATION_BRIGHTNESS: {
                    this.saturation = (float)MathHelper.clamp((mouseX - 20.0) / (double)mainWidth, 0.0, 1.0);
                    this.brightness = 1.0f - (float)MathHelper.clamp((mouseY - 20.0) / (double)mainHeight, 0.0, 1.0);
                    this.setColorText(Color.HSBtoRGB(this.hue, this.saturation, this.brightness), true);
                    break;
                }
                case HUE: {
                    this.hue = (float)MathHelper.clamp((mouseY - 20.0) / (double)mainHeight, 0.0, 1.0);
                    this.setColorText(Color.HSBtoRGB(this.hue, this.saturation, this.brightness), true);
                }
            }
        }

        private void setHsb(int color, boolean padZero) {
            float[] hsb = Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, null);
            this.hue = hsb[0];
            this.saturation = hsb[1];
            this.brightness = hsb[2];
            this.setColorText(color, padZero);
        }

        private void setColorText(int color, boolean padZero) {
            String colorString = Integer.toHexString(color & 0xFFFFFF).toUpperCase(Locale.ENGLISH);
            this.textFieldColor.setText2(padZero ? StringUtils.leftPad((String)colorString, (int)6, (String)"0") : colorString);
            this.textFieldRed.setText2(String.valueOf(color >> 16 & 0xFF));
            this.textFieldGreen.setText2(String.valueOf(color >> 8 & 0xFF));
            this.textFieldBlue.setText2(String.valueOf(color & 0xFF));
            this.buttonReset.f_93623_ = (color & 0xFFFFFF) != this.oldColor;
        }

        private void textCallback(String text, int shift) {
            try {
                boolean isHex = shift < 0;
                int compare = Integer.parseInt(text, isHex ? 16 : 10);
                int currentColor = Color.HSBtoRGB(this.hue, this.saturation, this.brightness) & 0xFFFFFF;
                if ((isHex ? currentColor : currentColor >> shift & 0xFF) != compare) {
                    this.setHsb(isHex ? compare : (currentColor & ~(255 << shift)) + (compare << shift), !isHex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private int getMainWidth() {
            return this.f_96543_ - 100 - 60;
        }

        private int getMainHeight() {
            return this.f_96544_ - 40;
        }
    }

    private static enum DraggingState {
        NONE,
        SATURATION_BRIGHTNESS,
        HUE;

    }
}

