/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.ToLongFunction;
import javax.annotation.Nonnull;
import org.mtr.core.data.Data;
import org.mtr.core.data.NameColorDataBase;
import org.mtr.core.data.PathData;
import org.mtr.core.operation.VehicleLiftResponse;
import org.mtr.core.operation.VehicleUpdate;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.mapping.mapper.EntityHelper;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.VehicleExtension;
import org.mtr.mod.packet.PacketRequestResponseBase;
import org.mtr.mod.render.RenderVehicles;

public final class PacketUpdateVehiclesLifts
extends PacketRequestResponseBase {
    public PacketUpdateVehiclesLifts(PacketBufferReceiver packetBufferReceiver) {
        super(packetBufferReceiver);
    }

    public PacketUpdateVehiclesLifts(VehicleLiftResponse vehicleLiftResponse) {
        super(Utilities.getJsonObjectFromData(vehicleLiftResponse).toString());
    }

    private PacketUpdateVehiclesLifts(String content) {
        super(content);
    }

    @Override
    protected void runClientInbound(JsonReader jsonReader) {
        MinecraftClientData minecraftClientData = MinecraftClientData.getInstance();
        VehicleLiftResponse vehicleLiftResponse = new VehicleLiftResponse(jsonReader, (Data)minecraftClientData);
        boolean hasUpdate1 = PacketUpdateVehiclesLifts.updateVehiclesOrLifts(minecraftClientData.vehicles, vehicleLiftResponse::iterateVehiclesToKeep, vehicleLiftResponse::iterateVehiclesToUpdate, VehicleExtension::dispose, vehicleUpdate -> vehicleUpdate.getVehicle().getId(), vehicleUpdate -> new VehicleExtension((VehicleUpdate)vehicleUpdate, (Data)minecraftClientData));
        boolean hasUpdate2 = PacketUpdateVehiclesLifts.updateVehiclesOrLifts(minecraftClientData.lifts, vehicleLiftResponse::iterateLiftsToKeep, vehicleLiftResponse::iterateLiftsToUpdate, removedLift -> {}, NameColorDataBase::getId, lift -> lift);
        vehicleLiftResponse.iterateSignalBlockUpdates(signalBlockUpdate -> {
            minecraftClientData.railIdToPreBlockedSignalColors.put(signalBlockUpdate.getRailId(), signalBlockUpdate.getPreBlockedSignalColors());
            minecraftClientData.railIdToCurrentlyBlockedSignalColors.put(signalBlockUpdate.getRailId(), signalBlockUpdate.getCurrentlyBlockedSignalColors());
        });
        if (hasUpdate1 || hasUpdate2) {
            if (hasUpdate1) {
                EntityHelper.HIDDEN_PLAYERS.clear();
                minecraftClientData.vehicles.forEach(vehicle -> {
                    PathData.writePathCache(vehicle.vehicleExtraData.immutablePath, new MinecraftClientData(), vehicle.getTransportMode());
                    vehicle.vehicleExtraData.iterateRidingEntities(vehicleRidingEntity -> EntityHelper.HIDDEN_PLAYERS.add(vehicleRidingEntity.uuid));
                });
                RenderVehicles.RIDING_PLAYER_INTERPOLATIONS.removeIf(ridingPlayerInterpolation -> EntityHelper.HIDDEN_PLAYERS.stream().noneMatch(uuid -> uuid.equals(ridingPlayerInterpolation.uuid)));
            }
            minecraftClientData.sync();
        }
    }

    @Override
    protected PacketRequestResponseBase getInstance(String content) {
        return new PacketUpdateVehiclesLifts(content);
    }

    @Override
    protected SerializedDataBase getDataInstance(JsonReader jsonReader) {
        return new SerializedDataBase(){

            @Override
            public void updateData(ReaderBase readerBase) {
            }

            @Override
            public void serializeData(WriterBase writerBase) {
            }
        };
    }

    @Override
    @Nonnull
    protected String getKey() {
        return "update_data";
    }

    @Override
    protected PacketRequestResponseBase.ResponseType responseType() {
        return PacketRequestResponseBase.ResponseType.NONE;
    }

    private static <T extends NameColorDataBase, U> boolean updateVehiclesOrLifts(ObjectArraySet<T> dataSet, Consumer<LongConsumer> iterateKeep, Consumer<Consumer<U>> iterateUpdate, Consumer<T> onRemove, ToLongFunction<U> getId, Function<U, T> createInstance) {
        LongAVLTreeSet keepIds = new LongAVLTreeSet();
        iterateKeep.accept(keepIds::add);
        LongAVLTreeSet updateIds = new LongAVLTreeSet();
        ObjectArrayList<Object> dataSetToUpdate = new ObjectArrayList<Object>();
        iterateUpdate.accept(dataToUpdate -> {
            dataSetToUpdate.add(dataToUpdate);
            updateIds.add(getId.applyAsLong(dataToUpdate));
        });
        Long2ObjectOpenHashMap removedItems = new Long2ObjectOpenHashMap();
        boolean itemRemoved = dataSet.removeIf(data -> {
            boolean shouldBeRemoved;
            boolean bl = shouldBeRemoved = !keepIds.contains(data.getId());
            if (shouldBeRemoved) {
                removedItems.put(data.getId(), data);
            }
            return shouldBeRemoved || updateIds.contains(data.getId());
        });
        dataSetToUpdate.forEach(dataToUpdate -> dataSet.add((NameColorDataBase)createInstance.apply(dataToUpdate)));
        dataSet.forEach(e -> removedItems.remove(e.getId()));
        removedItems.values().forEach(onRemove);
        return !dataSetToUpdate.isEmpty() || itemRemoved;
    }
}

