/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockDriverKeyDispenser;

public final class PacketUpdateKeyDispenserConfig
extends PacketHandler {
    private final BlockPos blockPos;
    private final boolean dispenseBasicDriverKey;
    private final boolean dispenseAdvancedDriverKey;
    private final boolean dispenseGuardKey;
    private final long timeout;

    public PacketUpdateKeyDispenserConfig(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong(packetBufferReceiver.readLong());
        this.dispenseBasicDriverKey = packetBufferReceiver.readBoolean();
        this.dispenseAdvancedDriverKey = packetBufferReceiver.readBoolean();
        this.dispenseGuardKey = packetBufferReceiver.readBoolean();
        this.timeout = packetBufferReceiver.readLong();
    }

    public PacketUpdateKeyDispenserConfig(BlockPos blockPos, boolean dispenseBasicDriverKey, boolean dispenseAdvancedDriverKey, boolean dispenseGuardKey, long timeout2) {
        this.blockPos = blockPos;
        this.dispenseBasicDriverKey = dispenseBasicDriverKey;
        this.dispenseAdvancedDriverKey = dispenseAdvancedDriverKey;
        this.dispenseGuardKey = dispenseGuardKey;
        this.timeout = timeout2;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeBoolean(this.dispenseBasicDriverKey);
        packetBufferSender.writeBoolean(this.dispenseAdvancedDriverKey);
        packetBufferSender.writeBoolean(this.dispenseGuardKey);
        packetBufferSender.writeLong(this.timeout);
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        if (!Init.isChunkLoaded(serverPlayerEntity.getEntityWorld(), this.blockPos)) {
            return;
        }
        BlockEntity entity = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos);
        if (entity != null && entity.data instanceof BlockDriverKeyDispenser.BlockEntity) {
            ((BlockDriverKeyDispenser.BlockEntity)((Object)entity.data)).setData(this.dispenseBasicDriverKey, this.dispenseAdvancedDriverKey, this.dispenseGuardKey, this.timeout);
        }
    }
}

