/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.client;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.mtr.core.data.TransportMode;
import org.mtr.core.tool.Utilities;
import org.mtr.legacy.resource.CustomResourcesConverter;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectBooleanImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.mapper.ResourceManagerHelper;
import org.mtr.mod.Init;
import org.mtr.mod.Keys;
import org.mtr.mod.config.Config;
import org.mtr.mod.resource.CustomResources;
import org.mtr.mod.resource.LiftResource;
import org.mtr.mod.resource.MinecraftModelResource;
import org.mtr.mod.resource.ObjectResource;
import org.mtr.mod.resource.OptimizedRendererWrapper;
import org.mtr.mod.resource.RailResource;
import org.mtr.mod.resource.SignResource;
import org.mtr.mod.resource.VehicleResource;

public class CustomResourceLoader {
    private static long TEST_DURATION;
    public static final OptimizedRendererWrapper OPTIMIZED_RENDERER_WRAPPER;
    public static final String CUSTOM_RESOURCES_ID = "mtr_custom_resources";
    public static final String CUSTOM_RESOURCES_PENDING_MIGRATION_ID = "mtr_custom_resources_pending_migration";
    public static final String DEFAULT_RAIL_ID = "default";
    public static final String DEFAULT_RAIL_3D_ID = "default_3d";
    public static final String DEFAULT_RAIL_3D_SIDING_ID = "default_3d_siding";
    public static final String DEFAULT_LIFT_TRANSPARENT_ID = "default_transparent";
    private static final Object2ObjectAVLTreeMap<String, String> RESOURCE_CACHE;
    private static final Object2ObjectAVLTreeMap<TransportMode, ObjectArrayList<VehicleResource>> VEHICLES;
    private static final Object2ObjectAVLTreeMap<TransportMode, Object2ObjectAVLTreeMap<String, ObjectBooleanImmutablePair<VehicleResource>>> VEHICLES_CACHE;
    private static final Object2ObjectAVLTreeMap<TransportMode, Object2ObjectAVLTreeMap<String, Object2ObjectAVLTreeMap<String, ObjectArrayList<String>>>> VEHICLES_TAGS;
    private static final ObjectArrayList<SignResource> SIGNS;
    private static final Object2ObjectAVLTreeMap<String, SignResource> SIGNS_CACHE;
    private static final ObjectArrayList<RailResource> RAILS;
    private static final Object2ObjectAVLTreeMap<String, RailResource> RAILS_CACHE;
    private static final ObjectArrayList<ObjectResource> OBJECTS;
    private static final Object2ObjectAVLTreeMap<String, ObjectResource> OBJECTS_CACHE;
    private static final ObjectArraySet<MinecraftModelResource> MINECRAFT_MODEL_RESOURCES;
    private static final ObjectArraySet<String> MINECRAFT_TEXTURE_RESOURCES;
    private static final ObjectArrayList<LiftResource> LIFTS;
    private static final Object2ObjectAVLTreeMap<String, LiftResource> LIFTS_CACHE;

    public static void reload() {
        MINECRAFT_MODEL_RESOURCES.clear();
        MINECRAFT_TEXTURE_RESOURCES.clear();
        RESOURCE_CACHE.clear();
        VEHICLES.forEach((transportMode, vehicleResources) -> vehicleResources.clear());
        VEHICLES_CACHE.forEach((transportMode, vehicleResourcesCache) -> vehicleResourcesCache.clear());
        VEHICLES_TAGS.forEach((transportMode, vehicleResourcesCache) -> vehicleResourcesCache.clear());
        SIGNS.clear();
        SIGNS_CACHE.clear();
        RAILS.clear();
        RAILS_CACHE.clear();
        OBJECTS.clear();
        OBJECTS_CACHE.clear();
        LIFTS.clear();
        LIFTS_CACHE.clear();
        TEST_DURATION = 0L;
        ObjectArrayList<SignResource> defaultSigns = new ObjectArrayList<SignResource>();
        RailResource defaultRailResource = new RailResource(DEFAULT_RAIL_ID, "Default", CustomResourceLoader::readResource);
        RAILS.add(defaultRailResource);
        RAILS_CACHE.put(DEFAULT_RAIL_ID, defaultRailResource);
        ResourceManagerHelper.readAllResources(new Identifier("mtr", "mtr_custom_resources.json"), inputStream2 -> {
            try {
                CustomResources customResources = CustomResourcesConverter.convert(Config.readResource(inputStream2).getAsJsonObject(), CustomResourceLoader::readResource);
                customResources.iterateVehicles(vehicleResource -> CustomResourceLoader.registerVehicle(vehicleResource, false));
                customResources.iterateSigns(signResource -> {
                    if (signResource.isDefault) {
                        defaultSigns.add((SignResource)signResource);
                    } else {
                        SIGNS.add((SignResource)signResource);
                        SIGNS_CACHE.put(signResource.signId, (SignResource)signResource);
                    }
                });
                customResources.iterateRails(railResource -> {
                    RAILS.add((RailResource)railResource);
                    RAILS_CACHE.put(railResource.getId(), (RailResource)railResource);
                });
                customResources.iterateObjects(objectResource -> {
                    OBJECTS.add((ObjectResource)objectResource);
                    OBJECTS_CACHE.put(objectResource.getId(), (ObjectResource)objectResource);
                });
                customResources.iterateLifts(liftResource -> {
                    LIFTS.add((LiftResource)liftResource);
                    LIFTS_CACHE.put(liftResource.getId(), (LiftResource)liftResource);
                });
            }
            catch (Exception e) {
                Init.LOGGER.error("", (Throwable)e);
            }
        });
        ResourceManagerHelper.readAllResources(new Identifier("mtr", "mtr_custom_resources_pending_migration.json"), inputStream2 -> {
            try {
                CustomResourcesConverter.convert(Config.readResource(inputStream2).getAsJsonObject(), CustomResourceLoader::readResource).iterateVehicles(vehicleResource -> CustomResourceLoader.registerVehicle(vehicleResource, false));
            }
            catch (Exception e) {
                Init.LOGGER.error("", (Throwable)e);
            }
        });
        SIGNS.addAll(0, (ObjectList<SignResource>)defaultSigns);
        defaultSigns.forEach(signResource -> SIGNS_CACHE.put(signResource.signId, (SignResource)signResource));
        CustomResourcesConverter.convertRails(railResource -> {
            RAILS.add((RailResource)railResource);
            RAILS_CACHE.put(railResource.getId(), (RailResource)railResource);
        }, CustomResourceLoader::readResource);
        CustomResourcesConverter.convertObjects(objectResource -> {
            OBJECTS.add((ObjectResource)objectResource);
            OBJECTS_CACHE.put(objectResource.getId(), (ObjectResource)objectResource);
        }, CustomResourceLoader::readResource);
        VEHICLES.forEach((transportMode, vehicleResources) -> CustomResourceLoader.validateDataset("Vehicle", vehicleResources, VehicleResource::getId));
        CustomResourceLoader.validateDataset("Sign", SIGNS, signResource -> signResource.signId);
        CustomResourceLoader.validateDataset("Rail", RAILS, RailResource::getId);
        CustomResourceLoader.validateDataset("Object", OBJECTS, ObjectResource::getId);
        CustomResourceLoader.validateDataset("Lift", LIFTS, LiftResource::getId);
        Init.LOGGER.info("Loaded {} vehicles and completed door movement validation in {} ms", (Object)VEHICLES.values().stream().mapToInt(ObjectArrayList::size).reduce(0, Integer::sum), (Object)((double)TEST_DURATION / 1000000.0));
        Init.LOGGER.info("Loaded {} signs", (Object)SIGNS.size());
        Init.LOGGER.info("Loaded {} rails", (Object)RAILS.size());
        Init.LOGGER.info("Loaded {} objects", (Object)OBJECTS.size());
        Init.LOGGER.info("Loaded {} lifts", (Object)LIFTS.size());
        long time1 = System.currentTimeMillis();
        int[] preloadedVehicleCount = new int[]{0};
        VEHICLES.forEach((transportMode, vehicleResources) -> vehicleResources.forEach(vehicleResource -> {
            if (vehicleResource.shouldPreload) {
                vehicleResource.getCachedVehicleResource(0, 0, true);
                preloadedVehicleCount[0] = preloadedVehicleCount[0] + 1;
            }
        }));
        long time2 = System.currentTimeMillis();
        if (preloadedVehicleCount[0] > 0) {
            Init.LOGGER.info("Preloaded {} vehicles in {} ms", (Object)preloadedVehicleCount[0], (Object)(time2 - time1));
        }
        int[] preloadedRailCount = new int[]{0};
        RAILS.forEach(railResource -> {
            if (railResource.shouldPreload) {
                railResource.preload();
                preloadedRailCount[0] = preloadedRailCount[0] + 1;
            }
        });
        long time3 = System.currentTimeMillis();
        if (preloadedRailCount[0] > 0) {
            Init.LOGGER.info("Preloaded {} rails in {} ms", (Object)preloadedRailCount[0], (Object)(time3 - time2));
        }
        int[] preloadedObjectCount = new int[]{0};
        OBJECTS.forEach(objectResource -> {
            if (objectResource.shouldPreload) {
                objectResource.preload();
                preloadedObjectCount[0] = preloadedObjectCount[0] + 1;
            }
        });
        long time4 = System.currentTimeMillis();
        if (preloadedObjectCount[0] > 0) {
            Init.LOGGER.info("Preloaded {} objects in {} ms", (Object)preloadedObjectCount[0], (Object)(time4 - time3));
        }
    }

    public static void iterateVehicles(TransportMode transportMode, Consumer<VehicleResource> consumer) {
        VEHICLES.get((Object)transportMode).forEach(consumer);
    }

    public static void clearCustomVehicles(String vehicleId) {
        for (TransportMode transportMode : TransportMode.values()) {
            ObjectArrayList<String> vehicleIdsToRemove = new ObjectArrayList<String>();
            VEHICLES_CACHE.get((Object)transportMode).values().forEach(vehicleResourceDetails -> {
                VehicleResource vehicleResource = (VehicleResource)vehicleResourceDetails.left();
                if (vehicleResourceDetails.rightBoolean() && (vehicleId.isEmpty() || vehicleResource.getId().equals(vehicleId))) {
                    vehicleIdsToRemove.add(vehicleResource.getId());
                    VEHICLES.get((Object)transportMode).remove(vehicleResource);
                    VEHICLES_TAGS.get((Object)transportMode).remove(vehicleResource.getId());
                }
            });
            vehicleIdsToRemove.forEach(checkVehicleId -> VEHICLES_CACHE.get((Object)transportMode).remove(checkVehicleId));
        }
    }

    public static void registerVehicle(VehicleResource vehicleResource) {
        CustomResourceLoader.registerVehicle(vehicleResource, true);
    }

    private static <T> void validateDataset(String dataSetName, List<T> dataSet, Function<T, String> getId) {
        ObjectOpenHashSet<String> addedIds = new ObjectOpenHashSet<String>();
        for (T data : dataSet) {
            String id = getId.apply(data);
            if (addedIds.contains(id)) {
                Init.LOGGER.warn("MTR {} resource contains duplicated id {}!", (Object)dataSetName, (Object)id);
                continue;
            }
            addedIds.add(id);
        }
    }

    public static void getVehicleByIndex(TransportMode transportMode, int index, Consumer<VehicleResource> ifPresent) {
        VehicleResource vehicleResource;
        if (index >= 0 && (vehicleResource = (VehicleResource)Utilities.getElement(VEHICLES.get((Object)transportMode), index)) != null) {
            ifPresent.accept(vehicleResource);
        }
    }

    public static void getVehicleById(TransportMode transportMode, String vehicleId, Consumer<ObjectBooleanImmutablePair<VehicleResource>> ifPresent) {
        ObjectBooleanImmutablePair<VehicleResource> vehicleResourceDetails = VEHICLES_CACHE.get((Object)transportMode).get(vehicleId);
        if (vehicleResourceDetails != null) {
            ifPresent.accept(vehicleResourceDetails);
        }
    }

    public static Object2ObjectAVLTreeMap<String, Object2ObjectAVLTreeMap<String, ObjectArrayList<String>>> getVehicleTags(TransportMode transportMode) {
        return VEHICLES_TAGS.get((Object)transportMode);
    }

    public static void getSignById(String signId, Consumer<SignResource> ifPresent) {
        SignResource signResource = SIGNS_CACHE.get(signId);
        if (signResource != null) {
            ifPresent.accept(signResource);
        }
    }

    public static ObjectArrayList<String> getSortedSignIds() {
        return SIGNS.stream().map(signResource -> signResource.signId).collect(Collectors.toCollection(ObjectArrayList::new));
    }

    public static ObjectImmutableList<RailResource> getRails() {
        return new ObjectImmutableList<RailResource>((ObjectList<RailResource>)RAILS);
    }

    public static void getRailById(String railId, Consumer<RailResource> ifPresent) {
        RailResource railResource = RAILS_CACHE.get(railId);
        if (railResource != null) {
            ifPresent.accept(railResource);
        }
    }

    public static ObjectImmutableList<ObjectResource> getObjects() {
        return new ObjectImmutableList<ObjectResource>((ObjectList<ObjectResource>)OBJECTS);
    }

    public static void getObjectById(String objectId, Consumer<ObjectResource> ifPresent) {
        ObjectResource objectResource = OBJECTS_CACHE.get(objectId);
        if (objectResource != null) {
            ifPresent.accept(objectResource);
        }
    }

    public static ObjectImmutableList<LiftResource> getLifts() {
        return new ObjectImmutableList<LiftResource>((ObjectList<LiftResource>)LIFTS);
    }

    public static void getLiftById(String liftId, Consumer<LiftResource> ifPresent) {
        LiftResource liftResource = LIFTS_CACHE.get(liftId);
        if (liftResource != null) {
            ifPresent.accept(liftResource);
        }
    }

    public static void incrementTestDuration(long duration) {
        TEST_DURATION += duration;
    }

    public static ObjectArrayList<MinecraftModelResource> getMinecraftModelResources() {
        return new ObjectArrayList<MinecraftModelResource>((ObjectCollection<MinecraftModelResource>)MINECRAFT_MODEL_RESOURCES);
    }

    public static ObjectArrayList<String> getTextureResources() {
        return new ObjectArrayList<String>((ObjectCollection<String>)MINECRAFT_TEXTURE_RESOURCES);
    }

    private static void registerVehicle(VehicleResource vehicleResource, boolean fromResourcePackCreator) {
        VEHICLES.get((Object)vehicleResource.getTransportMode()).add(vehicleResource);
        VEHICLES_CACHE.get((Object)vehicleResource.getTransportMode()).put(vehicleResource.getId(), new ObjectBooleanImmutablePair<VehicleResource>(vehicleResource, fromResourcePackCreator));
        vehicleResource.collectTags(VEHICLES_TAGS.get((Object)vehicleResource.getTransportMode()));
        if (!fromResourcePackCreator) {
            vehicleResource.writeMinecraftResource(MINECRAFT_MODEL_RESOURCES, MINECRAFT_TEXTURE_RESOURCES);
        }
    }

    private static String readResource(Identifier identifier) {
        String identifierString = ((ResourceLocation)identifier.data).toString();
        String cache = RESOURCE_CACHE.get(identifierString);
        if (cache == null) {
            if (Keys.DEBUG) {
                String string;
                block10: {
                    InputStream inputStream2 = Files.newInputStream(MinecraftClient.getInstance().getRunDirectoryMapped().toPath().resolve("../src/main/resources/assets").resolve(identifier.getNamespace()).resolve(identifier.getPath()), StandardOpenOption.READ);
                    try {
                        String content = IOUtils.toString((InputStream)inputStream2, (Charset)StandardCharsets.UTF_8);
                        RESOURCE_CACHE.put(identifierString, content);
                        string = content;
                        if (inputStream2 == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream2 != null) {
                                try {
                                    inputStream2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            Init.LOGGER.error("", (Throwable)e);
                            return "";
                        }
                    }
                    inputStream2.close();
                }
                return string;
            }
            String content = ResourceManagerHelper.readResource(identifier);
            RESOURCE_CACHE.put(identifierString, content);
            return content;
        }
        return cache;
    }

    static {
        OPTIMIZED_RENDERER_WRAPPER = new OptimizedRendererWrapper();
        RESOURCE_CACHE = new Object2ObjectAVLTreeMap();
        VEHICLES = new Object2ObjectAVLTreeMap();
        VEHICLES_CACHE = new Object2ObjectAVLTreeMap();
        VEHICLES_TAGS = new Object2ObjectAVLTreeMap();
        SIGNS = new ObjectArrayList();
        SIGNS_CACHE = new Object2ObjectAVLTreeMap();
        RAILS = new ObjectArrayList();
        RAILS_CACHE = new Object2ObjectAVLTreeMap();
        OBJECTS = new ObjectArrayList();
        OBJECTS_CACHE = new Object2ObjectAVLTreeMap();
        MINECRAFT_MODEL_RESOURCES = new ObjectArraySet();
        MINECRAFT_TEXTURE_RESOURCES = new ObjectArraySet();
        LIFTS = new ObjectArrayList();
        LIFTS_CACHE = new Object2ObjectAVLTreeMap();
        for (TransportMode transportMode : TransportMode.values()) {
            VEHICLES.put(transportMode, new ObjectArrayList());
            VEHICLES_CACHE.put(transportMode, new Object2ObjectAVLTreeMap());
            VEHICLES_TAGS.put(transportMode, new Object2ObjectAVLTreeMap());
        }
    }
}

