/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.SoundHelper;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.BlockEntityTypes;
import org.mtr.mod.block.BlockTrainSensorBase;
import org.mtr.mod.client.IDrawing;

public class BlockTrainAnnouncer
extends BlockTrainSensorBase {
    private static final Long2ObjectAVLTreeMap<ObjectArrayList<Runnable>> QUEUE = new Long2ObjectAVLTreeMap();

    @Override
    @Nonnull
    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    public static void processQueue() {
        LongArrayList itemsToRemove = new LongArrayList();
        long currentMillis = System.currentTimeMillis();
        QUEUE.forEach((BiConsumer<Long, ObjectArrayList<Runnable>>)((BiConsumer<Long, ObjectArrayList>)(time, tasks) -> {
            if (time <= currentMillis) {
                tasks.forEach(Runnable::run);
                itemsToRemove.add((long)time);
            }
        }));
        itemsToRemove.forEach(QUEUE::remove);
    }

    public static class BlockEntity
    extends BlockTrainSensorBase.BlockEntityBase
    implements Utilities {
        private String message = "";
        private String soundId = "";
        private int delay;
        private long lastAnnouncedMillis;
        private static final int ANNOUNCE_COOLDOWN_MILLIS = 20000;
        private static final String KEY_MESSAGE = "message";
        private static final String KEY_SOUND_ID = "sound_id";
        private static final String KEY_DELAY = "delay";

        public BlockEntity(BlockPos pos, BlockState state) {
            super((BlockEntityType<?>)BlockEntityTypes.TRAIN_ANNOUNCER.get(), pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.message = compoundTag.getString(KEY_MESSAGE);
            this.soundId = compoundTag.getString(KEY_SOUND_ID);
            this.delay = compoundTag.getInt(KEY_DELAY);
            super.readCompoundTag(compoundTag);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putString(KEY_MESSAGE, this.message);
            compoundTag.putString(KEY_SOUND_ID, this.soundId);
            compoundTag.putInt(KEY_DELAY, this.delay);
            super.writeCompoundTag(compoundTag);
        }

        public void setData(LongAVLTreeSet filterRouteIds, boolean stoppedOnly, boolean movingOnly, String message, String soundId, int delay) {
            this.message = message;
            this.soundId = soundId;
            this.delay = delay;
            this.setData(filterRouteIds, stoppedOnly, movingOnly);
        }

        public String getMessage() {
            return this.message;
        }

        public String getSoundId() {
            return this.soundId;
        }

        public int getDelay() {
            return this.delay;
        }

        public void announce() {
            long currentMillis = System.currentTimeMillis();
            if (currentMillis - this.lastAnnouncedMillis >= 20000L) {
                ObjectArrayList<Runnable> tasks = new ObjectArrayList<Runnable>();
                QUEUE.put(currentMillis + (long)this.delay * 1000L, tasks);
                if (!this.message.isEmpty()) {
                    tasks.add(() -> IDrawing.narrateOrAnnounce(Utilities.formatName(this.message), Arrays.stream(this.message.split("\\|")).map(TextHelper::literal).collect(Collectors.toCollection(ObjectArrayList::new))));
                }
                if (!this.soundId.isEmpty()) {
                    tasks.add(() -> {
                        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
                        if (clientPlayerEntity != null) {
                            clientPlayerEntity.playSound(SoundHelper.createSoundEvent(new Identifier(this.soundId)), 1000.0f, 1.0f);
                        }
                    });
                }
                this.lastAnnouncedMillis = currentMillis;
            }
        }
    }
}

