/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.BlockEntityTypes;
import org.mtr.mod.Items;
import org.mtr.mod.block.BlockPSDAPGGlassBase;
import org.mtr.mod.block.BlockPSDTop;
import org.mtr.mod.block.IBlock;

public class BlockAPGGlass
extends BlockPSDAPGGlassBase
implements BlockWithEntity {
    public static final IntegerProperty ARROW_DIRECTION = IntegerProperty.of("propagate_property", 0, 3);

    @Override
    @Nonnull
    public Item asItem2() {
        return Items.APG_GLASS.get();
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        double y = hit.getPos().getYMapped();
        if (IBlock.getStatePropertySafe(state, HALF) == IBlock.DoubleBlockHalf.UPPER && y - Math.floor(y) > 0.21875) {
            return IBlock.checkHoldingBrush(world, player, () -> {
                world.setBlockState(pos, state.cycle(new org.mtr.mapping.holder.Property((Property)BlockAPGGlass.ARROW_DIRECTION.data)));
                this.propagate(world, pos, IBlock.getStatePropertySafe(state, FACING).rotateYClockwise(), new org.mtr.mapping.holder.Property((Property)BlockAPGGlass.ARROW_DIRECTION.data), 3);
                this.propagate(world, pos, IBlock.getStatePropertySafe(state, FACING).rotateYCounterclockwise(), new org.mtr.mapping.holder.Property((Property)BlockAPGGlass.ARROW_DIRECTION.data), 3);
            });
        }
        return super.onUse2(state, world, pos, player, hand, hit);
    }

    @Override
    @Nonnull
    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(HALF);
        properties.add(SIDE_EXTENDED);
        properties.add(ARROW_DIRECTION);
    }

    public static class BlockEntity
    extends BlockPSDTop.BlockEntityBase {
        public BlockEntity(BlockPos pos, BlockState state) {
            super((BlockEntityType<?>)BlockEntityTypes.APG_GLASS.get(), pos, state);
        }
    }
}

