/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.WorldChunk;

public final class MainEventBus {
    Consumer<MinecraftServer> serverStartingConsumer = minecraftServer -> {};
    Consumer<MinecraftServer> serverStartedConsumer = minecraftServer -> {};
    Consumer<MinecraftServer> serverStoppingConsumer = minecraftServer -> {};
    Consumer<MinecraftServer> serverStoppedConsumer = minecraftServer -> {};
    Runnable startServerTickRunnable = () -> {};
    Runnable endServerTickRunnable = () -> {};
    Consumer<ServerWorld> startWorldTickRunnable = world -> {};
    Consumer<ServerWorld> endWorldTickRunnable = world -> {};
    BiConsumer<MinecraftServer, ServerPlayerEntity> playerJoinRunnable = (minecraftServer, serverPlayerEntity) -> {};
    BiConsumer<MinecraftServer, ServerPlayerEntity> playerDisconnectRunnable = (minecraftServer, serverPlayerEntity) -> {};
    BiConsumer<ServerWorld, WorldChunk> chunkLoadConsumer = (world, chunk) -> {};
    BiConsumer<ServerWorld, WorldChunk> chunkUnloadConsumer = (world, chunk) -> {};
    final List<Consumer<CommandDispatcher<CommandSourceStack>>> commands = new ArrayList<Consumer<CommandDispatcher<CommandSourceStack>>>();

    @SubscribeEvent
    public void serverStarting(ServerStartingEvent event) {
        this.serverStartingConsumer.accept(new MinecraftServer(event.getServer()));
    }

    @SubscribeEvent
    public void serverStarted(ServerStartedEvent event) {
        this.serverStartedConsumer.accept(new MinecraftServer(event.getServer()));
    }

    @SubscribeEvent
    public void serverStopping(ServerStoppingEvent event) {
        this.serverStoppingConsumer.accept(new MinecraftServer(event.getServer()));
    }

    @SubscribeEvent
    public void serverStopped(ServerStoppedEvent event) {
        this.serverStoppedConsumer.accept(new MinecraftServer(event.getServer()));
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        switch (event.phase) {
            case START: {
                this.startServerTickRunnable.run();
                break;
            }
            case END: {
                this.endServerTickRunnable.run();
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.LevelTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.level instanceof ServerLevel) {
            switch (event.phase) {
                case START: {
                    this.startWorldTickRunnable.accept(new ServerWorld((ServerLevel)event.level));
                    break;
                }
                case END: {
                    this.endWorldTickRunnable.accept(new ServerWorld((ServerLevel)event.level));
                }
            }
        }
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player playerEntity = event.getEntity();
        if (playerEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)playerEntity;
            this.playerJoinRunnable.accept(new MinecraftServer(serverPlayerEntity.f_8924_), new ServerPlayerEntity(serverPlayerEntity));
        }
    }

    @SubscribeEvent
    public void playerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        Player playerEntity = event.getEntity();
        if (playerEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)playerEntity;
            this.playerDisconnectRunnable.accept(new MinecraftServer(serverPlayerEntity.f_8924_), new ServerPlayerEntity(serverPlayerEntity));
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load event) {
        if (event.getLevel() instanceof ServerLevel && event.getChunk() instanceof LevelChunk) {
            this.chunkLoadConsumer.accept(new ServerWorld((ServerLevel)event.getLevel()), new WorldChunk((LevelChunk)event.getChunk()));
        }
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Load event) {
        if (event.getLevel() instanceof ServerLevel && event.getChunk() instanceof LevelChunk) {
            this.chunkUnloadConsumer.accept(new ServerWorld((ServerLevel)event.getLevel()), new WorldChunk((LevelChunk)event.getChunk()));
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        this.commands.forEach(consumer -> consumer.accept(event.getDispatcher()));
    }
}

