/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Particle;
import org.mtr.mapping.holder.SpriteBillboardParticle;
import org.mtr.mapping.holder.SpriteProvider;
import org.mtr.mapping.tool.DummyClass;

public abstract class ParticleFactoryExtension
implements ParticleProvider<SimpleParticleType> {
    private final CreateParticle createParticle;
    private final CreateSpriteBillboardParticle createSpriteBillboardParticle;
    private final SpriteProvider spriteProvider;

    @MappedMethod
    public ParticleFactoryExtension(CreateParticle createParticle, SpriteProvider spriteProvider) {
        this.createParticle = createParticle;
        this.createSpriteBillboardParticle = null;
        this.spriteProvider = spriteProvider;
    }

    @MappedMethod
    public ParticleFactoryExtension(CreateSpriteBillboardParticle createSpriteBillboardParticle, SpriteProvider spriteProvider) {
        this.createParticle = null;
        this.createSpriteBillboardParticle = createSpriteBillboardParticle;
        this.spriteProvider = spriteProvider;
    }

    @Deprecated
    public final net.minecraft.client.particle.Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        if (this.createParticle != null) {
            return (net.minecraft.client.particle.Particle)this.createParticle.create((ClientWorld)new ClientWorld((ClientLevel)clientWorld), (double)x, (double)y, (double)z, (double)velocityX, (double)velocityY, (double)velocityZ).data;
        }
        if (this.createSpriteBillboardParticle != null) {
            SpriteBillboardParticle spriteBillboardParticle = this.createSpriteBillboardParticle.create(new ClientWorld(clientWorld), x, y, z, velocityX, velocityY, velocityZ);
            ((TextureSheetParticle)spriteBillboardParticle.data).m_108335_((SpriteSet)this.spriteProvider.data);
            return (net.minecraft.client.particle.Particle)spriteBillboardParticle.data;
        }
        NullPointerException nullPointerException = new NullPointerException("Both createParticle and createSpriteBillboardParticle are null!");
        DummyClass.logException(nullPointerException);
        throw nullPointerException;
    }

    @FunctionalInterface
    public static interface CreateParticle {
        @MappedMethod
        public Particle create(ClientWorld var1, double var2, double var4, double var6, double var8, double var10, double var12);
    }

    @FunctionalInterface
    public static interface CreateSpriteBillboardParticle {
        @MappedMethod
        public SpriteBillboardParticle create(ClientWorld var1, double var2, double var4, double var6, double var8, double var10, double var12);
    }
}

