/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.sounds.SoundSource;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum SoundCategory {
    MASTER(SoundSource.MASTER),
    MUSIC(SoundSource.MUSIC),
    RECORDS(SoundSource.RECORDS),
    WEATHER(SoundSource.WEATHER),
    BLOCKS(SoundSource.BLOCKS),
    HOSTILE(SoundSource.HOSTILE),
    NEUTRAL(SoundSource.NEUTRAL),
    PLAYERS(SoundSource.PLAYERS),
    AMBIENT(SoundSource.AMBIENT),
    VOICE(SoundSource.VOICE);

    public final SoundSource data;

    private SoundCategory(SoundSource data) {
        this.data = data;
    }

    public static SoundCategory convert(@Nullable SoundSource data) {
        return data == null ? null : SoundCategory.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable SoundCategory data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public String getName() {
        return this.data.m_12676_();
    }

    @Nonnull
    @MappedMethod
    public static SoundCategory getRecordsMapped() {
        return SoundCategory.convert(SoundSource.RECORDS);
    }

    @Nonnull
    @MappedMethod
    public static SoundCategory getMusicMapped() {
        return SoundCategory.convert(SoundSource.MUSIC);
    }

    @Nonnull
    @MappedMethod
    public static SoundCategory getMasterMapped() {
        return SoundCategory.convert(SoundSource.MASTER);
    }

    @Nonnull
    @MappedMethod
    public static SoundCategory getHostileMapped() {
        return SoundCategory.convert(SoundSource.HOSTILE);
    }

    @Nonnull
    @MappedMethod
    public static SoundCategory getPlayersMapped() {
        return SoundCategory.convert(SoundSource.PLAYERS);
    }

    @Nonnull
    @MappedMethod
    public static SoundCategory getVoiceMapped() {
        return SoundCategory.convert(SoundSource.VOICE);
    }

    @Nonnull
    @MappedMethod
    public static SoundCategory getWeatherMapped() {
        return SoundCategory.convert(SoundSource.WEATHER);
    }

    @Nonnull
    @MappedMethod
    public static SoundCategory getBlocksMapped() {
        return SoundCategory.convert(SoundSource.BLOCKS);
    }

    @Nonnull
    @MappedMethod
    public static SoundCategory getAmbientMapped() {
        return SoundCategory.convert(SoundSource.AMBIENT);
    }

    @Nonnull
    @MappedMethod
    public static SoundCategory getNeutralMapped() {
        return SoundCategory.convert(SoundSource.NEUTRAL);
    }
}

