/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.oba;

import javax.annotation.Nonnull;
import org.mtr.core.oba.StopDirection;
import org.mtr.core.oba.WheelchairBoarding;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.core.tool.EnumHelper;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class StopSchema
implements SerializedDataBase {
    protected final String id;
    protected final String code;
    protected final String name;
    protected final String description;
    protected final double lat;
    protected final double lon;
    protected final String url;
    protected final long locationType;
    protected final WheelchairBoarding wheelchairBoarding;
    protected final StopDirection direction;
    protected final ObjectArrayList<String> routeIds = new ObjectArrayList();

    protected StopSchema(String id, String code, String name, String description, double lat, double lon, String url, long locationType, WheelchairBoarding wheelchairBoarding, StopDirection direction) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.description = description;
        this.lat = lat;
        this.lon = lon;
        this.url = url;
        this.locationType = locationType;
        this.wheelchairBoarding = wheelchairBoarding;
        this.direction = direction;
    }

    protected StopSchema(ReaderBase readerBase) {
        this.id = readerBase.getString("id", "");
        this.code = readerBase.getString("code", "");
        this.name = readerBase.getString("name", "");
        this.description = readerBase.getString("description", "");
        this.lat = readerBase.getDouble("lat", 0.0);
        this.lon = readerBase.getDouble("lon", 0.0);
        this.url = readerBase.getString("url", "");
        this.locationType = readerBase.getLong("locationType", 0L);
        this.wheelchairBoarding = EnumHelper.valueOf(WheelchairBoarding.values()[0], readerBase.getString("wheelchairBoarding", ""));
        this.direction = EnumHelper.valueOf(StopDirection.values()[0], readerBase.getString("direction", ""));
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        readerBase.iterateStringArray("routeIds", this.routeIds::clear, this.routeIds::add);
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        writerBase.writeString("id", this.id);
        writerBase.writeString("code", this.code);
        writerBase.writeString("name", this.name);
        writerBase.writeString("description", this.description);
        writerBase.writeDouble("lat", this.lat);
        writerBase.writeDouble("lon", this.lon);
        writerBase.writeString("url", this.url);
        writerBase.writeLong("locationType", this.locationType);
        writerBase.writeString("wheelchairBoarding", this.wheelchairBoarding.toString());
        writerBase.writeString("direction", this.direction.toString());
        this.serializeRouteIds(writerBase);
    }

    @Nonnull
    public String toString() {
        return "id: " + this.id + "\ncode: " + this.code + "\nname: " + this.name + "\ndescription: " + this.description + "\nlat: " + this.lat + "\nlon: " + this.lon + "\nurl: " + this.url + "\nlocationType: " + this.locationType + "\nwheelchairBoarding: " + (Object)((Object)this.wheelchairBoarding) + "\ndirection: " + (Object)((Object)this.direction) + "\nrouteIds: " + this.routeIds + "\n";
    }

    protected void serializeRouteIds(WriterBase writerBase) {
        WriterBase.Array routeIdsWriterBaseArray = writerBase.writeArray("routeIds");
        this.routeIds.forEach(routeIdsWriterBaseArray::writeString);
    }
}

