/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.data;

import javax.annotation.Nonnull;
import org.mtr.core.data.AreaBase;
import org.mtr.core.data.Data;
import org.mtr.core.data.Depot;
import org.mtr.core.data.Siding;
import org.mtr.core.data.TransportMode;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.core.tool.EnumHelper;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;

public abstract class DepotSchema
extends AreaBase<Depot, Siding> {
    protected final LongArrayList routeIds = new LongArrayList();
    protected long lastGeneratedMillis;
    protected Depot.GeneratedStatus lastGeneratedStatus = Depot.GeneratedStatus.values()[0];
    protected long lastGeneratedFailedStartId;
    protected long lastGeneratedFailedEndId;
    protected long lastGeneratedFailedSidingCount;
    protected boolean useRealTime;
    protected final LongArrayList frequencies = new LongArrayList();
    protected final LongArrayList realTimeDepartures = new LongArrayList();
    protected boolean repeatInfinitely;
    protected long cruisingAltitude = 256L;

    protected DepotSchema(TransportMode transportMode, Data data) {
        super(transportMode, data);
    }

    protected DepotSchema(ReaderBase readerBase, Data data) {
        super(readerBase, data);
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        super.updateData(readerBase);
        readerBase.iterateLongArray("routeIds", this.routeIds::clear, this.routeIds::add);
        readerBase.unpackLong("lastGeneratedMillis", value -> {
            this.lastGeneratedMillis = value;
        });
        readerBase.unpackString("lastGeneratedStatus", value -> {
            this.lastGeneratedStatus = EnumHelper.valueOf(Depot.GeneratedStatus.values()[0], value);
        });
        readerBase.unpackLong("lastGeneratedFailedStartId", value -> {
            this.lastGeneratedFailedStartId = value;
        });
        readerBase.unpackLong("lastGeneratedFailedEndId", value -> {
            this.lastGeneratedFailedEndId = value;
        });
        readerBase.unpackLong("lastGeneratedFailedSidingCount", value -> {
            this.lastGeneratedFailedSidingCount = value;
        });
        readerBase.unpackBoolean("useRealTime", value -> {
            this.useRealTime = value;
        });
        readerBase.iterateLongArray("frequencies", this.frequencies::clear, this.frequencies::add);
        readerBase.iterateLongArray("realTimeDepartures", this.realTimeDepartures::clear, this.realTimeDepartures::add);
        readerBase.unpackBoolean("repeatInfinitely", value -> {
            this.repeatInfinitely = value;
        });
        readerBase.unpackLong("cruisingAltitude", value -> {
            this.cruisingAltitude = value;
        });
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        super.serializeData(writerBase);
        this.serializeRouteIds(writerBase);
        this.serializeLastGeneratedMillis(writerBase);
        this.serializeLastGeneratedStatus(writerBase);
        this.serializeLastGeneratedFailedStartId(writerBase);
        this.serializeLastGeneratedFailedEndId(writerBase);
        this.serializeLastGeneratedFailedSidingCount(writerBase);
        this.serializeUseRealTime(writerBase);
        this.serializeFrequencies(writerBase);
        this.serializeRealTimeDepartures(writerBase);
        this.serializeRepeatInfinitely(writerBase);
        this.serializeCruisingAltitude(writerBase);
    }

    @Override
    @Nonnull
    public String toString() {
        return super.toString() + "routeIds: " + this.routeIds + "\nlastGeneratedMillis: " + this.lastGeneratedMillis + "\nlastGeneratedStatus: " + (Object)((Object)this.lastGeneratedStatus) + "\nlastGeneratedFailedStartId: " + this.lastGeneratedFailedStartId + "\nlastGeneratedFailedEndId: " + this.lastGeneratedFailedEndId + "\nlastGeneratedFailedSidingCount: " + this.lastGeneratedFailedSidingCount + "\nuseRealTime: " + this.useRealTime + "\nfrequencies: " + this.frequencies + "\nrealTimeDepartures: " + this.realTimeDepartures + "\nrepeatInfinitely: " + this.repeatInfinitely + "\ncruisingAltitude: " + this.cruisingAltitude + "\n";
    }

    protected void serializeRouteIds(WriterBase writerBase) {
        WriterBase.Array routeIdsWriterBaseArray = writerBase.writeArray("routeIds");
        this.routeIds.forEach(routeIdsWriterBaseArray::writeLong);
    }

    protected void serializeLastGeneratedMillis(WriterBase writerBase) {
        writerBase.writeLong("lastGeneratedMillis", this.lastGeneratedMillis);
    }

    protected void serializeLastGeneratedStatus(WriterBase writerBase) {
        writerBase.writeString("lastGeneratedStatus", this.lastGeneratedStatus.toString());
    }

    protected void serializeLastGeneratedFailedStartId(WriterBase writerBase) {
        writerBase.writeLong("lastGeneratedFailedStartId", this.lastGeneratedFailedStartId);
    }

    protected void serializeLastGeneratedFailedEndId(WriterBase writerBase) {
        writerBase.writeLong("lastGeneratedFailedEndId", this.lastGeneratedFailedEndId);
    }

    protected void serializeLastGeneratedFailedSidingCount(WriterBase writerBase) {
        writerBase.writeLong("lastGeneratedFailedSidingCount", this.lastGeneratedFailedSidingCount);
    }

    protected void serializeUseRealTime(WriterBase writerBase) {
        writerBase.writeBoolean("useRealTime", this.useRealTime);
    }

    protected void serializeFrequencies(WriterBase writerBase) {
        WriterBase.Array frequenciesWriterBaseArray = writerBase.writeArray("frequencies");
        this.frequencies.forEach(frequenciesWriterBaseArray::writeLong);
    }

    protected void serializeRealTimeDepartures(WriterBase writerBase) {
        WriterBase.Array realTimeDeparturesWriterBaseArray = writerBase.writeArray("realTimeDepartures");
        this.realTimeDepartures.forEach(realTimeDeparturesWriterBaseArray::writeLong);
    }

    protected void serializeRepeatInfinitely(WriterBase writerBase) {
        writerBase.writeBoolean("repeatInfinitely", this.repeatInfinitely);
    }

    protected void serializeCruisingAltitude(WriterBase writerBase) {
        writerBase.writeLong("cruisingAltitude", this.cruisingAltitude);
    }
}

