/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.cache;

import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public class LastAccessExtentCache
extends AbstractDelegateExtent {
    private CachedBlock<BlockState> lastBlock;
    private CachedBlock<BaseBlock> lastFullBlock;

    public LastAccessExtentCache(Extent extent) {
        super(extent);
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        CachedBlock<BlockState> lastBlock = this.lastBlock;
        if (lastBlock != null && ((CachedBlock)lastBlock).position.equals(position)) {
            return (BlockState)((CachedBlock)lastBlock).block;
        }
        BlockState block = super.getBlock(position);
        this.lastBlock = new CachedBlock(position, block, null);
        return block;
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        CachedBlock<BaseBlock> lastFullBlock = this.lastFullBlock;
        if (lastFullBlock != null && ((CachedBlock)lastFullBlock).position.equals(position)) {
            return (BaseBlock)((CachedBlock)lastFullBlock).block;
        }
        BaseBlock block = super.getFullBlock(position);
        this.lastFullBlock = new CachedBlock(position, block, null);
        return block;
    }

    @Override
    public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 location, T block) throws WorldEditException {
        if (super.setBlock(location, block)) {
            if (this.lastFullBlock != null && ((CachedBlock)this.lastFullBlock).position.equals(location)) {
                this.lastFullBlock = new CachedBlock(location, block.toBaseBlock(), null);
            }
            if (this.lastBlock != null && ((CachedBlock)this.lastBlock).position.equals(location)) {
                this.lastBlock = new CachedBlock(location, block.toImmutableState(), null);
            }
            return true;
        }
        return false;
    }

    private static class CachedBlock<B extends BlockStateHolder<B>> {
        private final BlockVector3 position;
        private final B block;

        private CachedBlock(BlockVector3 position, B block) {
            this.position = position;
            this.block = block;
        }

        /* synthetic */ CachedBlock(BlockVector3 x0, BlockStateHolder x1, 1 x2) {
            this(x0, x1);
        }
    }
}

