/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosconstructionmod.entity;

import de.sarocesch.sarosconstructionmod.block.entity.WheelbarrowBlockEntity;
import de.sarocesch.sarosconstructionmod.init.SarosConstructionModModBlocks;
import de.sarocesch.sarosconstructionmod.init.SarosConstructionModModEntities;
import de.sarocesch.sarosconstructionmod.world.inventory.WheelbarrowGUIMenu;
import io.netty.buffer.Unpooled;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class WheelbarrowEntityEntity
extends PathfinderMob {
    private boolean isMoving = false;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final ItemStackHandler inventory = new ItemStackHandler(36){

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});

    public WheelbarrowEntityEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<WheelbarrowEntityEntity>)((EntityType)SarosConstructionModModEntities.WHEELBARROW_ENTITY.get()), world);
    }

    public WheelbarrowEntityEntity(EntityType<WheelbarrowEntityEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.0f);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof Player) {
            if (!this.m_9236_().m_5776_()) {
                BlockPos pos = this.m_20183_();
                if (this.m_9236_().m_8055_(pos).m_60713_(Blocks.f_50016_)) {
                    this.m_9236_().m_7731_(pos, (BlockState)((Block)SarosConstructionModModBlocks.WHEELBARROW.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)this.m_6350_()), 3);
                    BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
                    if (blockEntity instanceof WheelbarrowBlockEntity) {
                        WheelbarrowBlockEntity wheelbarrowBlockEntity = (WheelbarrowBlockEntity)blockEntity;
                        LazyOptional blockInventoryOpt = wheelbarrowBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
                        blockInventoryOpt.ifPresent(blockInventory -> {
                            LazyOptional entityInventoryOpt = this.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
                            entityInventoryOpt.ifPresent(entityInventory -> {
                                for (int i = 0; i < entityInventory.getSlots(); ++i) {
                                    ItemStack remainingStack;
                                    ItemStack stack = entityInventory.getStackInSlot(i);
                                    if (stack.m_41619_()) continue;
                                    for (int j = 0; j < blockInventory.getSlots() && !(remainingStack = blockInventory.insertItem(j, stack, false)).m_41619_(); ++j) {
                                    }
                                }
                            });
                        });
                    }
                    this.m_142687_(Entity.RemovalReason.KILLED);
                } else {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && side == null) {
            return LazyOptional.of(() -> this.combined).cast();
        }
        return super.getCapability(capability, side);
    }

    protected void m_5907_() {
        super.m_5907_();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.m_19983_(itemstack);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("InventoryCustom", (Tag)this.inventory.serializeNBT());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        Tag inventoryCustom = compound.m_128423_("InventoryCustom");
        if (inventoryCustom instanceof CompoundTag) {
            CompoundTag inventoryTag = (CompoundTag)inventoryCustom;
            this.inventory.deserializeNBT(inventoryTag);
        }
    }

    public InteractionResult m_6071_(final Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        boolean isShiftKeyDown = sourceentity.m_6144_();
        if (isShiftKeyDown) {
            if (sourceentity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)sourceentity;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237113_((String)"Wheelbarrow Entity");
                    }

                    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                        packetBuffer.m_130064_(sourceentity.m_20183_());
                        packetBuffer.writeByte(0);
                        packetBuffer.m_130130_(WheelbarrowEntityEntity.this.m_19879_());
                        return new WheelbarrowGUIMenu(id, inventory, packetBuffer);
                    }
                }, buf -> {
                    buf.m_130064_(sourceentity.m_20183_());
                    buf.writeByte(0);
                    buf.m_130130_(this.m_19879_());
                });
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.isMoving) {
                this.scheduler.shutdownNow();
                this.isMoving = false;
            } else {
                this.isMoving = true;
                this.scheduler = Executors.newScheduledThreadPool(1);
                this.scheduler.scheduleAtFixedRate(() -> this.moveWheelbarrow(sourceentity), 0L, 100L, TimeUnit.MILLISECONDS);
            }
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    private void moveWheelbarrow(Player sourceentity) {
        BlockPos newPos;
        double distanceInFront = 2.0;
        double angleInRadians = Math.toRadians(sourceentity.m_146908_());
        double offsetX = -Math.sin(angleInRadians) * distanceInFront;
        double offsetZ = Math.cos(angleInRadians) * distanceInFront;
        double newX = sourceentity.m_20185_() + offsetX;
        double newZ = sourceentity.m_20189_() + offsetZ;
        BlockPos blockInFrontPos = newPos = new BlockPos((int)newX, (int)this.m_20186_(), (int)newZ);
        BlockState blockInFrontState = this.m_9236_().m_8055_(blockInFrontPos);
        BlockPos blockAboveInFrontPos = blockInFrontPos.m_7494_();
        BlockState blockAboveInFrontState = this.m_9236_().m_8055_(blockAboveInFrontPos);
        BlockPos blockTwoAboveInFrontPos = blockAboveInFrontPos.m_7494_();
        BlockState blockTwoAboveInFrontState = this.m_9236_().m_8055_(blockTwoAboveInFrontPos);
        if (!blockInFrontState.m_60795_() && blockInFrontState.m_60819_().m_76178_()) {
            this.m_6034_(newX, this.m_20186_() + 1.0, newZ);
        } else {
            BlockPos blockUnderPos = newPos.m_7495_();
            BlockState blockUnderState = this.m_9236_().m_8055_(blockUnderPos);
            if (!blockUnderState.m_60795_() && blockUnderState.m_60819_().m_76178_()) {
                double newY = (double)blockUnderPos.m_123342_() + 1.0;
                this.m_6034_(newX, newY, newZ);
            } else {
                BlockPos blockBelowCurrentPos = this.m_20183_().m_7495_();
                BlockState blockBelowCurrentState = this.m_9236_().m_8055_(blockBelowCurrentPos);
                if (blockBelowCurrentState.m_60795_() || !blockBelowCurrentState.m_60819_().m_76178_()) {
                    double newY = this.m_20186_() - 1.0;
                    this.m_6034_(newX, newY, newZ);
                } else {
                    this.m_6034_(newX, this.m_20186_(), newZ);
                }
            }
        }
        this.m_146922_(sourceentity.m_146908_() + 180.0f);
        this.f_20883_ = this.m_146908_();
        this.f_20885_ = this.m_146908_();
        this.m_20256_(Vec3.f_82478_);
        this.f_19812_ = true;
    }

    public void m_7023_(Vec3 travelVector) {
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_6144_()) {
                this.m_8127_();
            } else {
                super.m_7023_(travelVector);
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 1.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }
}

